#!/bin/bash
# Differente methode pour obtenir la version de CentOS
# full=`cat /etc/centos-release | tr -dc '0-9.'`
centos_major=$(cat /etc/centos-release | tr -dc '0-9.'|cut -d \. -f1)
# minor=$(cat /etc/centos-release | tr -dc '0-9.'|cut -d \. -f2)
# asynchronous=$(cat /etc/centos-release | tr -dc '0-9.'|cut -d \. -f3)

CONFIGDIR="/home/local/etc/.gcv6"


# Verifier si l'utilisateur actuel est 'gestcom'
if [ "$(whoami)" != "gestcom" ]; then
    echo "Seul gestcom peut lancer ce script."
    exit 3
fi


if [ $centos_major -ne 6 ]; then
  echo "Ce script est destine UNIQUEMENT a CentOS 6. Vous utilisez CentOS $centos_major."
  exit 1
fi

prevVersion=$(awk -F';' 'NR==2 {print $1}' $CONFIGDIR/deploiement.csv)

printf "Voulez-vous installer la version %s ? (o/n) : " "$prevVersion"
read -r response
if [[ "$response" == "o" ]]; then
  ln -sf /home/local/bin/${prevVersion}/gtk2/bin/* /home/gcv6/
  ln -sf /home/local/bin/${prevVersion}/txt/bin/* /home/gestcom/
fi
