# ==============================================================================
#  EMC2 2023.07.25: Script d'automatisation des mdf
#
# Le script parcourt tous les fichiers commenant par "mdf" suivis
# de chiffres dans le rpertoire courant. Il demande  l'utilisateur
# s'il souhaite excuter chaque fichier trouv, mais n'excute rellement
# les fichiers qu' partir du fichier ayant le nom "mdf$VERSION"
# (o $VERSION est remplac par une version spcifique). Le reste des fichiers
# aprs celui-ci sera excut sans poser de questions  l'utilisateur.
# ==============================================================================

BUILD_NUM= # Ne pas supprimer/modifier cette ligne. Elle sera renseigne par le script de release.

# ----------------- Dterminer la version actuelle
# Lire la version dans informix
VERSION=$(isql gc << EOF
SELECT version FROM gc_parsys;
EOF
)

if [ $? -ne 0 ]
then
    echo "Impossible de lire la version dans gc_parsys"
    exit 1
fi

echo -n "VERSION actuelle : "
VERSION=$(echo "$VERSION" | tr '\n' ' ') # remplacer les retours  la lignes par une espace
VERSION=$(echo "$VERSION" | tr -s ' ') # Supprimer les espaces multiples
VERSION=$(echo $VERSION | cut -d" " -f2) # Recuperer le version
VERSION=$(echo $VERSION | sed 's/\.//g') # Supprimer les points

echo "$VERSION"
echo ""

# ------- Parcourir tous les fichiers mdf et n'afficher que ceux que l'on doit excuter
mdfAFaire=0
version_file="mdf$VERSION"

#MDF_TMPL pushd DOSSIER_MDF # Ne pas supprimer cette ligne. Elle sera renseigne par le script de release.

# Sauvegarde les fichiers mdf dans un tableau dans l'ordre inverse
mdfFiles=($(ls -r /home/local/bin/GCV6-6.06.015af/txt/etc/mdf[0-9]*))
nbFiles=${#mdfFiles[@]}

# Trouver l'index du fichier correspondant  "mdf$VERSION"
idx_start=-1
for index in ${!mdfFiles[@]}; do
    if [ $(basename ${mdfFiles[index]}) == $version_file ]; then
        idx_start=$((index-1))
        break
    fi
done


# Sortir si il n'y a aucun mdf a lanc
if [ $idx_start == -1 ]
then
    echo "Aucun mdf a faire"
    echo "version base : $VERSION"
    echo "dernier mdf : ${mdfFiles[0]}"
    exit 0
fi

mkdir -p /home/log/$(basename $DBPATH)
# Parcourt tous les mdf a faire et uniquement ceux la, dans l'ordre croissant
for (( i=$idx_start; i>=0; i--))
do
    mdfFile=${mdfFiles[i]}
    filename=$(basename $mdfFile)
    while true
    do
        read -p "Executer $mdfFile ? (o/n) " yn

        case $yn in
            [oO] ) sh $mdfFile 2>&1 | tee "/home/log/$(basename $DBPATH)/mdfauto-$filename.log" ;
                break;;
            [nN] ) echo "$mdfFile annule par vous...";
                exit 0;;
            * ) echo "Reponse invalide. Veuillez taper o ou n.";
        esac
    done
done
exit 0
