#!/bin/env bash

MODE=TXT

# Attention ! Ce script ne doit pas �tre modifi� chez le client.
# Il pr�sente et initialise les variabbles d'environnement pour le lancement de GCV.
# Les modifications seront faites dans le fichier gcdv.sh, gmx.sh, gm.sh etc


set -eo pipefail
# set -x
# Explication: https://gist.github.com/mohanpedala/1e2ff5661761d3abd0385e8223e16425
# set -e
#    - bash s'arr�te imm�diatement si une commande ne retourne pas le status 0
# set -x
#    - affiche toutes les commandes execut�es. Tr�s utiles pour le debug car montre l'encha�nement
# set -u
#    - Arr�te le programme d�s qu'on utilise une variable non d�finie
# set -o pipefail
#    -This setting prevents errors in a pipeline from being masked. If any command in a pipeline fails, that return code will be used as the return code of the whole pipeline. By default, the pipeline's return code is that of the last command even if it succeeds

#
# Essai de lancement direct
#

check_directory() {
    local dir="$1"

    if [ ! -d "$dir" ]; then
        if [ $MODE = "GTK" ]; then
            zenity --error --text="Directory '$dir' does not exist."
        else
            echo "Directory '$dir' does not exist."
        fi
        exit 1
    fi
}

# ======= Activation de l'environnement virtuel =======
# On active l'environnement virtuel Python
if [ ! -d /home/local/venv ]; then
    if [ $MODE = "GTK" ]; then
        zenity --error --text="Virtual environment not found at /home/local/venv. Please create it first."
    else
        echo "Virtual environment not found at /home/local/venv. Please create it first."
    fi
    exit 1
fi
source /home/local/venv/bin/activate


# ======= Variables a Configurer =======
GCV=/home/local/bin/GCV6-6.06.015af/txt/bin

# Defini des valeurs par defaut pour DBPATH, INFORMIXSERVER et INFORMIXDIR
# valeurs ecrasees si les variables d'environnement sont definies
export DBPATH="${DBPATH:-/home/bases/jdeuro}"
export INFORMIXSERVER="${INFORMIXSERVER:-gc}"
export INFORMIXDIR="${INFORMIXDIR:-/home/informix}"


# On verifie que les dossiers existent
check_directory "${DBPATH}"
check_directory "${INFORMIXDIR}"
# ======= Fin Variables a Configurer =======


# Configurer latex
# TODO Mettre texlive dans ansible
# export PATH=/home/local/texlive/2025/bin/x86_64-linux:~/bin:$PATH
export PATH=/home/local/texlive/bin/x86_64-linux:~/bin:$PATH

export LC_MESSAGES=fr_FR
# MAIL=/usr/spool/mail/`logname`

# disable mail checking
# MAILCHECK=0
EDITOR=vim

if [[ $MODE != "GTK" ]]; then
    export TERMCAP=${TERMCAP:-/home/local/bin/GCV6-6.06.015af/txt/etc/termcap}
fi

export LD_LIBRARY_PATH=$INFORMIXDIR/lib:$INFORMIXDIR/lib/esql:/usr/local/lib64${LD_LIBRARY_PATH:+:${LD_LIBRARY_PATH}}

export PATH=$INFORMIXDIR/bin:/home/local/bin/GCV6-6.06.015af/txt/bin:$PATH
export LANG=en_GB

export DBEDIT=${DBEDIT:-emacs}
export DBDATE=${DBDATE:-DMY4-}

export RIGHTPATH="${RIGHTPATH:-$DBPATH}"
export LSTPATH="${LSTPATH:-$HOME}"
export PRNLIBPATH="${PRNLIBPATH:-$DBPATH}"

export FACPATH="${FACPATH:-$DBPATH}"
export RECPATH="${RECPATH:-$DBPATH}"
export RELPATH="${RELPATH:-$DBPATH}"
export FMTETIQ="${FMTETIQ:-$DBPATH/FORMAT.LIB}"
export TRMFILE="${TRMFILE:-/tmp/invenptc}"

export RPTDIR="${RPTDIR:-$DBPATH/rpt}"

export SCRIPTPATH=${SCRIPTPATH:-$DBPATH/liaisons}
export UNLPATH=${UNLPATH:-$DBPATH/unl}

# export GCV6CLIFTP=1
# export GCV6CLIFTPPORT="${GCV6CLIFTPPORT:-0}"
if [ $MODE = "GTK" ]; then
    export GCINBOX=1 # Activer GCINBOX, valable uniquement en GTK>=3
fi


ulimit -c unlimited

# Determiner la version de CENTOS
major=$(cat /etc/centos-release | tr -dc '0-9.'|cut -d \. -f1)

if [ $major -lt 9 ]; then
    export LD_LIBRARY_PATH=/opt/zlib-1.3.1/lib:/opt/slog/lib:/opt/openssl-3.2.1/lib64:/opt/libxlsxwriter-1.1.9/lib64:/opt/cJSON-1.7/lib64${LD_LIBRARY_PATH:+:${LD_LIBRARY_PATH}}
fi



set_TERM() {
    if [ ! -f $TERMCAP ]; then
        echo "Le fichier $TERMCAP n'existe pas"
        exit 1
    fi

    # Ne pas utiliser TERM=xterm-256color
    if [ $TERM = "xterm-256color" ]; then
        unset TERM
    fi

    if [ -z "$TERM" ]; then
        if [[ $(grep -c vt220-132 $TERMCAP) -eq 1 ]]; then
            export TERM="vt220-132"
        elif [[ $(grep -c vt220 $TERMCAP) -eq 1 ]]; then
            export TERM="vt220"
        else
            export TERM="xterm"
        fi
    fi

}

is_ssh_with_who() {
    # ZSH fonction https://github.com/blueyed/oh-my-zsh/blob/master/functions/is_ssh
    # Check if the session is an SSH connection
    if [[ -n "$SSH_CONNECTION" ]]; then
        # Return the display name associated with the SSH connection
        local whoami_output
        whoami_output="$(who am i 2>/dev/null)"
        local host="${whoami_output#*(*}"
        host="${host%)}"

        # Check if the host indicates an SSH connection
        if [[ "$host" != "$whoami_output" && "$host" != tmux* ]]; then
            if [[ "$host" == "::1" || "$host" != :* ]]; then
                echo "$host"  # Return the host as the associated display
                return 0
            fi
        fi
    fi

    # Not an SSH connection, return an empty string
    echo ""
    return 1
}

is_ssh(){
    if [[ -n "$SSH_CONNECTION" ]]; then
        local ssh_details=($SSH_CONNECTION)
        echo ${ssh_details[0]}
        # echo ${ssh_details[0]:ssh_details[1]}
        return 0
    fi
    # Ce n'est pas une connexion SSH, retourne une chaine vide
    echo ""
    return 1
}

is_ssh2(){
    # export DISPLAY=$(SSH_CLIENT%:*):0.0
    if [[ -n "$SSH_CLIENT" ]]; then
        local ssh_details=($SSH_CLIENT)
        echo ${ssh_details[0]}
        # echo ${ssh_details[0]:ssh_details[1]}
        return 0
    fi
    # Ce n'est pas une connexion SSH, retourne une chaine vide
    echo ""
    return 1
}

set_DISPLAY()
{
    export DISPLAYPORT="${DISPLAYPORT:-0.0}"

    if [ -z $DISPLAY ]; then
        if [ is_ssh ]; then
            export DISPLAY=$(is_ssh):$DISPLAYPORT
        else
            if [ $MODE = "GTK" ]; then
                zenity --error --text="Impossible de déterminer le DISPLAY car DISPLAY est vide et ce n'est pas une connexion SSH" --title="NO DISPLAY"
            else
                echo "Impossible de déterminer le DISPLAY car DISPLAY vide et pas de connexion SSH"
            fi
            exit 1
        fi
    fi
}

if [[ "$MODE" != "GTK" ]]; then
     set_TERM
fi
set_DISPLAY


# Pour activer le 2eme ecran, il faut definir la variable d'environnement GMXSCREEN2_ACTIVE a 1
# toute autre valeur ou l'absence de cette variable desactive le 2eme ecran
export GMXSCREEN2_ACTIVE="${GMXSCREEN2_ACTIVE:-0}"
# Veuillez placer les images dans le dossier $DBPATH/gmx_images. Seules les 5 premi�res sont prises en compte
# 1366 x 768
export SCREEN2_TREELINE="${SCREEN2_TREELINE:-'15;#7c8e3a;#ffffff'}"
export TREELINESIZE="${TREELINESIZE:-'xxl'}"
#export TREELINECOLOR="${TREELINECOLOR:-#7c8e3a}"

# On mets une valeur invalide uniquement pour que la variable soit d�finie
# et non utilisable si l'utilisateur ne l'a pas d�finie
# une valeur possible est 1000x700+0+10
export SCREEN1_WHXY="${SCREEN1_WHXY:-HEIGHTxWIDTH+XPOS+YPOS}"
export SCREEN2_WHXY="${SCREEN2_WHXY:-HEIGHTxWIDTH+XPOS+YPOS}"


GTK_VERSION_USED=0


if [ $MODE = "GTK" ]; then
    # Lancer le programme
    if [ $major -eq 9 ]  && [ $GTK_VERSION_USED -eq 2 ] ; then
        # https://www.linuxtricks.fr/wiki/print.php?id=545
        export GTK2_RC_FILES=$1.gtkrc
        # .gtkrc-2.0 file location can be changed using GTK2_RC_FILES env variable. e.g.:
        # export GTK2_RC_FILES=/home/local/bin/GCV6-6.06.015af/txt/bin/gtk-2.0/gtkrc
    fi
fi
if [ $major -lt 9 ]; then
    umask 0
fi

#bash $CHEMIN/VERS/gcv_env.sh gm 3 2 2 2>&1 | tee -a ~/gm-${TODAY}.log

# beaucoup de logs --------> 0 LOG
# ALL, TRACE, DEBUG, INFO, WARN, ERROR, FATAL, NOLOG
export LOG_LEVEL="${LOG_LEVEL:-ALL}"
export LOG_TO_SCREEN="${LOG_TO_SCREEN:-0}"
mkdir -p /home/log/$(basename ${DBPATH})/daily


NOW=$(date +"%Y%m%d-%H%M%S")
TODAY=$(date +"%Y%m%d")


if [ $MODE = "GTK" ] && [ $GTK_VERSION_USED -ge 3 ]; then
    export CSSPATH="${CSSPATH:-/home/local/bin/GCV6-6.06.015af/txt/bin}"
fi

# On lance le programme
#if [ $MODE != "GTK" ] || [ $GTK_VERSION_USED -eq 2 ]; then
#    # ON se déplace dans le dossier de l'application
#    cd /home/local/bin/GCV6-6.06.015af/txt/bin/
#$@
#else
#/home/local/bin/GCV6-6.06.015af/txt/bin/$@
#fi


# URL du middleware GCMiddleware du client
# Exemples:
#   - D�veloppement: http://localhost:8001
export CLIENT_MIDDLEWARE_URL="${CLIENT_MIDDLEWARE_URL:-http://localhost:8001}"

export PYTHONPATH="/home/local/bin/GCV6-6.06.015af/txt/bin/../python:${PYTHONPATH:-}"

export PATH=/home/local/bin/GCV6-6.06.015af/txt/bin:$PATH
# if [ $MODE = "GTK" ] && [ $GTK_VERSION_USED -ge 3 ]; then
#     export GTK_THEME="Adwaita:light"
# fi
# if [ $GTK_VERSION_USED -lt 3 ]; then
# cd /home/local/bin/GCV6-6.06.015af/txt/bin/
# fi

# On lance le programme
# Supprimer le prefix "./" si il est présent
if [[ $1 == ./* ]]; then
    set -- "${1:2}" "${@:2}"
fi
$@
