"""
Registre des validateurs - Interface vers le système de destinations
"""
from typing import Optional, Callable
from app.destinations import get_all_validators
from app.destinations.fne_cdi.validators.base import ValidationResult


def get_validator(name: str) -> Optional[Callable[[dict], ValidationResult]]:
    """
    Récupère un validateur par son nom

    Args:
        name: Nom du validateur

    Returns:
        Fonction de validation ou None si non trouvé
    """
    validators = get_all_validators()
    return validators.get(name)


def validate_data(validator_name: str, data: dict) -> ValidationResult:
    """
    Valide des données avec le validateur spécifié

    Args:
        validator_name: Nom du validateur à utiliser
        data: Données à valider

    Returns:
        ValidationResult avec les erreurs éventuelles
    """
    validator = get_validator(validator_name)

    if validator is None:
        # Pas de validateur configuré, on accepte les données
        return ValidationResult(valid=True, data=data)

    return validator(data)
