CLAIR = {
    # clr    : (bg      ,  row1   , row2  , third)

    None     : ("black", None, None, None),

    "gris"   : ("gray3", "gray9", "white", "gray6"),
    "gray"   : ("gray3", "gray9", "white", "gray6"),
    "noir"   : ("gray3", "gray9", "white", "gray6"),
    "black"  : ("gray3", "gray9", "white", "gray6"),

    "bleu"   : ("azure3", "azure9", "white", "azure6"),
    "blue"   : ("azure3", "azure9", "white", "azure6"),

    "rouge"  : ("red3", "red9", "white",  "red6"),
    "red"    : ("red3", "red9", "white",  "red6"),

    "vert"   : ("teal3", "white", "teal9", "teal6"),
    "green"  : ("teal3", "white", "teal9", "teal6"),

    "violet" : ("violet3", "white", "violet9", "violet6"),
    "purple" : ("violet3", "white", "violet9", "violet6")
}

FONCE = {
    None : [None]*4,

    "gris"   : ("gray4", "gray2", "white", "white"),
    "gray"   : ("gray4", "gray2", "white", "white"),
    "noir"   : ("gray4", "gray2", "white", "white"),
    "black"  : ("gray4", "gray2", "white", "white"),

    "bleu"   : ("azure4", "azure2", "white", "white"),
    "blue"   : ("azure4", "azure2", "white", "white"),

    "rouge"  : ("red2", "red4", "white"),
    "red"    : ("red2", "red4", "white"),

    "vert"   : ("teal4", "teal2", "white",  "white"),
    "green"  : ("teal4", "teal2", "white",  "white"),

    "violet" : ("violet4", "violet2", "white", "white"),
    "purple" : ("violet4", "violet2", "white", "white")
}


class Couleurs:

    def __init__(self, couleur="gris", mode="clair"):
        # clr    : (bg      ,  row1   , row2  , third)
        self.couleur = couleur or None
        self.mode = mode or None
        self.bg, self.row1, self.row2, self.fg = self._colorSet()

    def _colorSet(self):
        if self.mode=="fonce":
            return  FONCE[self.couleur] if self.couleur in FONCE else FONCE["gris"]
        else:
            return CLAIR[self.couleur] if self.couleur in CLAIR else CLAIR["gris"]

    @classmethod
    def from_string(cls, style):
        d = style.split("_")
        couleur = d[0]
        mode = d[1] if len(d)>1 else "clair"

        return cls(couleur, mode)

