import sys
import sqlite3
import datetime

dbpath = sys.argv[1]

conn = sqlite3.connect(dbpath)
cursor = conn.cursor()
cursor.execute('''
    CREATE TABLE IF NOT EXISTS deployments (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        version TEXT NOT NULL,
        date TEXT NOT NULL,
        time TEXT NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )
''')
now = datetime.datetime.now()
cursor.execute('INSERT INTO deployments (version, date, time) VALUES (?, ?, ?)',
            ('GCV6-old', now.strftime('%Y%m%d'), now.strftime('%H%M%S')))
conn.commit()
conn.close()
