#!/bin/bash

# Configuration
DBNAME="gc"
TABLE="gc_ctax"
INDEXNAME="ix_ctax01"
DBACCESS="/usr/informix/bin/dbaccess"
DBACCESS="isql"


# Fichiers temporaires
ERRORLOG=$(mktemp)
SQLFILE=$(mktemp)

echo ">> Etape 1 : Repair de la table $TABLE et capture des erreurs..."

# Execution du REPAIR TABLE et redirection de stderr vers ERRORLOG
echo "repair table gc_ctax" | isql gc > "$ERRORLOG" 2>&1

echo ">> Etape 2 : Extraction des ROWID des doublons..."

# Extraire les rowid à partir de lignes comme : ERROR: duplicate key value, record 722893
ROWID_LIST=$(grep -E "ERROR: duplicate key value, record [0-9]+" "$ERRORLOG" \
    | grep -oE "[0-9]+" \
    | paste -sd ',' -)

if [ -z "$ROWID_LIST" ]; then
    echo "Aucun doublon trouve."
    rm "$ERRORLOG" "$SQLFILE"
    exit 0
fi

echo "Rowid en doublon detectes : $ROWID_LIST"

# Generer le fichier SQL à executer
cat <<EOF > "$SQLFILE"
-- Supprimer l'index existant
DROP INDEX $INDEXNAME;

-- Supprimer les lignes en doublon par rowid
DELETE FROM $TABLE WHERE rowid IN ($ROWID_LIST);

-- Recreer l'index
CREATE UNIQUE INDEX $INDEXNAME ON gc_ctax (code,numsoc,ind);

EOF

echo ">> Etape 3 : Suppression des doublons et recreation de l'index..."
$DBACCESS $DBNAME < "$SQLFILE"

# Nettoyage
cp "$ERRORLOG" "$SQLFILE" .
echo "Script termine."

