# Role gcmiddleware_service

Ce rôle configure le service gcmiddleware sur CentOS 6. Il permet de déployer plusieurs instances de middleware sur un même serveur, chacune avec son propre port et sa propre configuration.

## Description

Le middleware GCV est un routeur d'événements vers des APIs externes (FNE-CDI, etc.). Chaque instance de middleware:

- Écoute sur un port unique
- A sa propre base de données SQLite dans `$DBPATH/middleware.db`
- A son propre fichier de configuration `$DBPATH/config.toml`
- A son propre service init.d

## Prérequis

- CentOS 6
- Python 3.11+ installé dans `/home/local/venv`
- Middleware installé dans `/home/local/bin/GCV6/python/site-packages/gcmiddleware`
- Utilisateur `gestcom` créé

## Variables

### Variables par défaut (définies dans `defaults/main.yml`)

- `gcmiddleware_dir`: Répertoire d'installation du middleware (défaut: `/home/local/bin/GCV6/python/site-packages/gcmiddleware`)
- `gcmiddleware_user`: Utilisateur d'exécution (défaut: `gestcom`)
- `gcmiddleware_group`: Groupe d'exécution (défaut: `gestcom`)
- `gcmiddleware_venv`: Environnement virtuel Python (défaut: `/home/local/venv`)
- `gcmiddleware_stop_timeout`: Timeout pour l'arrêt gracieux en secondes (défaut: 30)

### Variables à définir au niveau du host

- `gcmiddleware_instances`: Liste des instances de middleware à configurer (voir exemple ci-dessous)

## Structure de gcmiddleware_instances

```yaml
gcmiddleware_instances:
  - name: gcmiddleware-yr                    # Nom du service
    port: 8001                                # Port d'écoute
    dbpath: /home/bases/yr                    # Chemin DBPATH
    host: 0.0.0.0                            # (Optionnel) Adresse d'écoute
    dev_mode: false                          # (Optionnel) Mode développement
    config:                                   # Configuration pour config.toml
      fne_cdi:
        token: "votre_token_fne"
        establishment: "Nom de l'établissement"
        pos: "Nom du point de vente"
        api:
          base_url: "http://54.247.95.108/ws/external/invoices/sign"
          timeout: 30
          max_retries: 5
        dev:                                  # (Optionnel) Mode développement
          enabled: false
          redirect_emails:
            - "dev@example.com"
          subject_prefix: "[DEV] "
      email:
        provider: brevo                       # ou mailgun
        brevo:
          api_key: "votre_api_key_brevo"
          from_email: "noreply@example.com"
          from_name: "Mon Magasin"
          invoice_template_id: 3              # (Optionnel) ID du template Brevo
          shop_name: "Mon Magasin"            # (Optionnel) Variables template
          shop_address: "Adresse du magasin"
          shop_phone: "+225 XX XX XX XX"
          shop_url: "https://example.com"
        notifications:
          admin_email: "admin@example.com"
      company:                                # (Optionnel)
        name: "Nom de l'entreprise"
        address: "Adresse complète"
        phone: "+225 XX XX XX XX"
        email: "contact@example.com"

  - name: gcmiddleware-adopt                  # Deuxième instance
    port: 8002
    dbpath: /home/bases/adopt
    config:
      # ... même structure que ci-dessus
```

## Exemple d'utilisation

### 1. Créer un fichier host_vars pour votre serveur

Créez `host_vars/monserveur.yml`:

```yaml
---
gcmiddleware_instances:
  - name: gcmiddleware-yr
    port: 8001
    dbpath: /home/bases/yr
    config:
      fne_cdi:
        token: "{{ vault_yr_fne_token }}"
        establishment: "Yves Rocher Playce Marcory"
        pos: "Caisse 1"
        api:
          base_url: "http://54.247.95.108/ws/external/invoices/sign"
      email:
        provider: brevo
        brevo:
          api_key: "{{ vault_yr_brevo_api_key }}"
          from_email: "noreply@yves-rocher.ci"
          from_name: "Yves Rocher CIV"
          invoice_template_id: 3
          shop_name: "Yves Rocher CIV"
          shop_address: "Bd Valery Giscard d Estaing, Abidjan"
          shop_phone: "+225 97175030"
          shop_url: "https://www.yves-rocher.ci"
        notifications:
          admin_email: "admin@yves-rocher.ci"

  - name: gcmiddleware-adopt
    port: 8002
    dbpath: /home/bases/adopt
    config:
      fne_cdi:
        token: "{{ vault_adopt_fne_token }}"
        establishment: "Adopt Parfums Abidjan"
        pos: "Caisse 1"
        api:
          base_url: "http://54.247.95.108/ws/external/invoices/sign"
      email:
        provider: brevo
        brevo:
          api_key: "{{ vault_adopt_brevo_api_key }}"
          from_email: "noreply@adopt-parfums.ci"
          from_name: "Adopt Parfums"
          invoice_template_id: 3
        notifications:
          admin_email: "admin@adopt-parfums.ci"
```

### 2. Stocker les secrets dans Ansible Vault

```bash
ansible-vault edit group_vars/all/vault.yml
```

Ajoutez:

```yaml
vault_yr_fne_token: "votre_token_secret_yr"
vault_yr_brevo_api_key: "votre_api_key_brevo_yr"
vault_adopt_fne_token: "votre_token_secret_adopt"
vault_adopt_brevo_api_key: "votre_api_key_brevo_adopt"
```

### 3. Utiliser le rôle dans un playbook

```yaml
- hosts: serveurs_gcv
  become: yes
  roles:
    - gcmiddleware_service
```

## Fichiers créés

Pour chaque instance, le rôle crée:

1. `/etc/init.d/gcmiddleware` - Script init.d principal
2. `/etc/init.d/{{ instance.name }}` - Lien symbolique vers le script principal
3. `/etc/sysconfig/{{ instance.name }}` - Configuration de l'instance
4. `{{ instance.dbpath }}/config.toml` - Configuration TOML du middleware
5. `{{ instance.dbpath }}/scripts/` - Dossier pour les scripts
6. `{{ instance.dbpath }}/scripts/send_json_facture_to_gcmiddleware_wrapper.sh` - Script wrapper pour l'envoi de factures (configuré avec le bon port)
7. `/home/log/{{ instance.dbpath | basename }}/daily/` - Dossier des logs

## Commandes de gestion des services

```bash
# Démarrer
service gcmiddleware-yr start

# Arrêter
service gcmiddleware-yr stop

# Redémarrer
service gcmiddleware-yr restart

# Statut détaillé
service gcmiddleware-yr status

# Voir les logs
service gcmiddleware-yr log

# Voir la configuration
service gcmiddleware-yr config

# Arrêt forcé
service gcmiddleware-yr forcestop
```

## Logs

Les logs sont créés dans:
```
/home/log/<dbname>/daily/<instance-name>.log
```

Par exemple:
- `/home/log/yr/daily/gcmiddleware-yr.log`
- `/home/log/adopt/daily/gcmiddleware-adopt.log`

Les logs du script wrapper d'envoi de factures:
- `/home/log/yr/daily/gestcom-send_facture_to_middleware.log`
- `/home/log/adopt/daily/gestcom-send_facture_to_middleware.log`

## Script wrapper d'envoi de factures

Le script `send_json_facture_to_gcmiddleware_wrapper.sh` est configuré automatiquement pour chaque instance avec:
- Le bon **port** du middleware (ex: 8001 pour yr, 8002 pour adopt)
- L'**environnement** (production par défaut, configurable via `item.config.environment`)
- Le chemin vers le script générique `/home/local/bin/scripts/gcmiddleware/send_json_facture_to_gcmiddleware.sh`

Ce script est appelé depuis la gestion (GCV) pour envoyer les factures au middleware qui les transmettra à l'API FNE-CDI.

**Usage depuis la gestion:**
```bash
$DBPATH/scripts/send_json_facture_to_gcmiddleware_wrapper.sh /tmp/facture_12345.json
```

## Handlers

Le rôle définit le handler `restart gcmiddleware services` qui redémarre toutes les instances configurées.

## Notes

- Chaque instance doit avoir un **port unique**
- Les tokens et clés API doivent être stockés dans Ansible Vault
- Le fichier `config.toml` doit être encodé en UTF-8 strict
- Pour valider le TOML: `python3 -c "import tomllib; tomllib.load(open('/home/bases/yr/config.toml', 'rb'))"`
- La base de données SQLite est automatiquement créée dans `$DBPATH/middleware.db`
