"""Fonctions pour interroger les factures dans la base de données."""

from typing import Dict, List, Tuple, Optional
from .itfifxpy import fetch_one, fetch_all


def OT_get_invoice_by_order_id(order_id: str) -> Tuple[bool, Dict[str, str]]:
    """Retourne la facture correspondant à l'identifiant de commande donné.

    Args:
        order_id: Identifiant de commande

    Returns:
        Tuple (found, invoice) où:
        - found: True si une facture a été trouvée
        - invoice: Dictionnaire avec les données de la facture (vide si non trouvé)

    Raises:
        ValueError: Si plusieurs factures sont trouvées pour l'identifiant de commande
    """
    columns = ["nofac", "cli", "dteinit", "rsoc", "total", "comment1"]

    sql = f"SELECT {','.join(columns)} FROM gc_fac WHERE comment1='{order_id}'"

    try:
        invoice = fetch_one(sql)

        if invoice is None:
            return False, {}

        return True, invoice

    except ValueError:
        raise ValueError(f"Plusieurs factures trouvées pour l'identifiant de commande {order_id}")


def OT_select_invoice_by_order_id(order_id: str) -> Tuple[int, List[Dict[str, str]]]:
    """Retourne toutes les factures correspondant à l'identifiant de commande donné.

    Args:
        order_id: Identifiant de commande

    Returns:
        Tuple (nbrows, invoices) où:
        - nbrows: Nombre de factures trouvées
        - invoices: Liste des factures (peut être vide)
    """
    columns = ["nofac", "cli", "dteinit", "rsoc", "total", "comment1"]

    sql = f"SELECT {','.join(columns)} FROM gc_fac WHERE comment1='{order_id}'"

    invoices = fetch_all(sql)
    return len(invoices), invoices
