"""Fonctions pour interroger la configuration CRM dans la base de données."""

from typing import Dict
from .itfifxpy import fetch_one


def get_active_crm() -> Dict[str, str]:
    """Récupère la configuration CRM active.

    Returns:
        Dictionnaire avec la configuration CRM (https, login, password, url, timeout, idmagasin, debug)

    Raises:
        ValueError: Si aucun CRM actif ou plusieurs CRM actifs sont trouvés
    """
    columns = ["https", "login", "password", "url", "timeout", "idmagasin", "debug"]

    sql = f"SELECT * FROM gc_crm WHERE actif=1"

    result = fetch_one(sql)

    if result is None:
        raise ValueError("Aucun CRM actif trouvé")

    sql2 = f"SELECT pays_alpha2, pays_alpha3 FROM gc_soc;"
    society = fetch_one(sql2)
    if society is None:
        raise ValueError("Aucune société trouvée")
    
    result["country"] = society.get("pays_alpha2", "FR")
    result["pays_alpha2"] = society.get("pays_alpha3", "FRA")
        
    return result


def print_active_crm():
    """Affiche la configuration CRM active."""
    try:
        active_crm = get_active_crm()
        print(active_crm)
    except ValueError as e:
        print(f"Erreur: {e}")
