"""Fonctions pour interroger les articles dans la base de données."""

from typing import Optional, List, Dict
from .itfifxpy import fetch_one, fetch_all


def get_article_by_codebarre(codebarres: str) -> Optional[Dict[str, str]]:
    """Récupère un article par son code-barres.

    Args:
        codebarres: Code-barres de l'article

    Returns:
        Dictionnaire avec la clé 'code' ou None si non trouvé

    Raises:
        ValueError: Si plusieurs articles ont le même code-barres
    """
    sql = f"SELECT code FROM gc_art WHERE bar='{codebarres}'"

    try:
        return fetch_one(sql)
    except ValueError as e:
        # Plusieurs articles trouvés
        print(f"Plusieurs articles ont ce code-barres {codebarres}: {e}")
        return None


def get_article_by_code(code: str) -> Optional[Dict[str, str]]:
    """Récupère un article complet par son code.

    Args:
        code: Code de l'article

    Returns:
        Dictionnaire avec toutes les colonnes de l'article ou None si non trouvé

    Raises:
        ValueError: Si plusieurs articles ont le même code
    """
    columns = [
        "code", "desig", "fam", "bar", "arf0_codfou", "arf0_pa",
        "arf3_codfou", "colcond", "colach", "unitc", "cont",
        "ecombl", "ecotaxe"
    ]

    sql = f"SELECT {','.join(columns)} FROM gc_art WHERE code='{code}'"

    try:
        return fetch_one(sql)
    except ValueError as e:
        # Plusieurs articles trouvés
        print(f"Plusieurs articles ont ce code {code}: {e}")
        return None


def get_vrev_by_code(code: str) -> List[Dict[str, str]]:
    """Récupère l'historique des prix d'un article.

    Args:
        code: Code de l'article

    Returns:
        Liste des historiques de prix (peut être vide)
    """
    columns = ["codart", "iddep", "dernpa", "dernpr", "pvht", "rev"]

    sql = f"SELECT {','.join(columns)} FROM gc_vrev WHERE codart='{code}'"

    return fetch_all(sql)
