"""
Plugin Kiabi pour gescokit.

Ce module fournit des outils pour parser et convertir les fichiers CSV
d'invoices et slips générés par le système OneTouch pour Kiabi.

Modules
-------
invoice_parser
    Parser pour les fichiers CSV d'invoices
slip_parser
    Parser pour les fichiers CSV de slips (avoirs)
converter
    Convertisseur vers Excel et SQLite
cli
    Interface en ligne de commande (invoices)
cli_slip
    Interface en ligne de commande (slips)

Examples
--------
>>> from gescokit.partners.kiabi import KiabiInvoiceParser, KiabiSlipParser
>>> # Parser invoices
>>> invoice_parser = KiabiInvoiceParser()
>>> invoice_lines = invoice_parser.parse_file("invoice-123-20250101-XXXXX.csv")
>>> # Parser slips
>>> slip_parser = KiabiSlipParser()
>>> slip_lines = slip_parser.parse_file("slip-123-20250101-XXXXX.csv")
"""

from .invoice_parser import (
    InvoiceKiabiLine,
    KiabiInvoiceParser
)

from .slip_parser import (
    SlipKiabiLine,
    KiabiSlipParser
)

from .converter import (
    KiabiInvoiceConverter
)

__all__ = [
    "InvoiceKiabiLine",
    "KiabiInvoiceParser",
    "SlipKiabiLine",
    "KiabiSlipParser",
    "KiabiInvoiceConverter",
]

__version__ = "1.1.0"
