import hashlib
from pathlib import Path
import re

def verifier_checksum(zippath):
  """Lit le checksum dans le fichier .sha et compare avec le hash du fichier zip
  Parameters
  ----------
  zippath: Path
      Chemin vers le fichier zip
  """
  shafile = zippath.with_suffix(".sha")
  SHAERROR = True # Par défaut, on considère que le fichier zip est corrompu

  if not shafile.is_file():
      SHAINFO = "Impossible de trouver le fichier contenant le hash du fichier zip."
  else:
      with open(shafile) as f:
        sha = f.readline().strip().lower()
        computed_sha = hashlib.sha512(open(zippath, "rb").read()).hexdigest().lower()
        if sha != computed_sha:
            SHAINFO = "Le fichier zip est corrompu. Le hash ne correspond pas."
        else:
            SHAINFO = "Le hash calculé correspond au fichier zip."
            SHAERROR = False
            print("Le fichier zip est correctement signé.")

  return SHAERROR, SHAINFO


def get_centos_release()-> int:
    """Retourne le numéro majeur de version de la centos"""
    if Path("/etc/centos-release").is_file():
        with open("/etc/centos-release") as fp:
            line = fp.readline()
            matched = re.search("(\d)", line.strip())
            if matched:
                return int(matched.group(0))
    print("makearch: Impossible d'obtenir la version de centos. /etc/centos-release n'est pas un fichier")
    return None


def split_emc2_csv_line(line, sep=";") -> list:
    """Supprime le point-virgule final et retourne une liste"""
    l = line.strip()
    if l.endswith(";"):
        l=l[:-1]
    return l.split(";")