from pathlib import Path

from .tools import split_emc2_csv_line

root = Path(__file__).parent

SHOW_CSVNAME_AS_SUBTITLE=True


def open_html(file, navbar=None, SHA=None):
    with open(str(root / "templates/html/head.html")) as head:
        txt = "\n".join(head.readlines())
    with open(file, "w") as html:
        print(txt, file=html)
        if navbar:
            print(generer_navbar(navbar), file=html)
        if SHA:
            SHAERROR, SHAINFO = SHA
            if SHAERROR:
                alert_class = "alert-danger"
            else:
                alert_class = "alert-success"
            print(
                '<div class="alert {}" role="alert">{}</div>'.format(
                    alert_class, SHAINFO
                ),
                file=html,
            )

        print('<div class="container-fluid">', file=html)


def close_html(file):
    with open(str(root / "templates/html/footer.html")) as head:
        txt = "\n".join(head.readlines())
    with open(file, "a") as html:
        print(txt, file=html)


def generer_navbar(navbar):
    html = """<nav class="navbar navbar-expand navbar-dark bg-dark sticky-top">
<div class="container-fluid">
<ul class="navbar-nav">
    """
    for nav in navbar:
        html += (
            '<li class="nav-item"><a class="nav-link" href="#{}">{}</a></li>'.format(
                nav["id"], nav["titre"]
            )
        )
    html += "</nav>"
    return html


def table_head(colnames):
    html = "<thead>\n"
    html += "<tr>\n"
    for name in colnames:
        html += "<th>{}</th>".format(name)
    html += "</tr>\n"
    html += "</thead>\n"

    return html


def table_body(data, styles=None):
    """
    data est une liste de liste
    """
    html = "<tbody>\n"

    if styles is not None:
        if len(data) > len(styles):
            raise ValueError("Le nombre de styles doit être égal au nombre de colonnes")
    else:
        if data:
            styles = [""] * len(data[0])
    for row in data:
        html += "<tr>\n"
        for col, style in zip(row, styles):
            html += "<td class='align-middle {}'>{}</td>".format(style, col)
        html += "\n"
        html += "</tr>\n"
    html += "</thead>\n"

    return html


def table(colnames, data, styles=None):
    # Vérifier si certaines colonnes doivent être affichées sous forme de tableau dans une unique cellule
    # Un élément de colnames est un dictionnaire si la colonne doit être affichée sous forme de tableau.
    # Cet élément de colnames contient :
    #   - dans la clé "title", le nouveau titre de la colonne,
    #   - dans la clé "csvnames", la liste des colonnes à rassembler dans le tableau,
    #   - dans la clé "names": la liste des titres des colonnes du tableau à intégrer dans la cellule
    array_in_cell = [idx for idx, col in enumerate(colnames) if isinstance(col, dict)][
        ::-1
    ]
    new_data = data
    if array_in_cell:
        new_data = []

        for idx in array_in_cell:
            subtab_info = colnames[idx]

            # title = subtab_info["title"]

            subtab_colnames = subtab_info["names"]
            csvcolnames = subtab_info["csvcolnames"]

            for row in data:
                idx_end = idx + len(csvcolnames)
                extracted_cols = row[idx:idx_end]
                reformated_data = []
                i = 0
                while i < len(extracted_cols):
                    reformated_data.append(extracted_cols[i : i + 2])
                    i += 2

                newrow = row[:idx]
                newrow.append(table(subtab_colnames, reformated_data))
                newrow.extend(row[idx_end:])
                new_data.append(newrow)

        colnames = [col["title"] if isinstance(col, dict) else col for col in colnames]

    html = "<table class='table table-striped'>\n"

    html += table_head(colnames) + table_body(new_data, styles)
    html += "</table>\n"
    return html

def lire_archive(csvname, colnames, id_nav, titre, styles=None, subtitle=None):
    """Retourne navigation et tableau html"""
    csvname = "output/" + csvname
    if not Path(csvname).is_file():
        print("Impossible de trouver", csvname)
        return None, None

    navigations = [{"id": id_nav, "titre": titre}]

    with open(csvname, encoding="cp850") as fp:
        data = [split_emc2_csv_line(line) for line in fp if line.strip()]

    html_txt = table_wrapper(table(colnames, data), id_nav, titre, subtitle=subtitle)

    return navigations, html_txt


def table_wrapper(table, id_nav, titre, subtitle=None):
    html = "<section id='{}'>\n".format(id_nav)
    html += "<h1>{}</h1>".format(titre)
    if subtitle:
        html += "<h5>{}</h5>".format(subtitle)
    # if SHOW_CSVNAME_AS_SUBTITLE:
    #     html_txt += "<em><small>{}</small></em>".format(csvname)
    html += table
    html += "</section>\n"

    return html