from pathlib import Path


from .to_html import open_html, close_html, generer_navbar, lire_archive
from .facture import archive_facture

kwargs = {"delimiter": ";", "index_col": False, "dtype": str, "encoding": "cp850"}
html_kwargs = {
    "index": False,
    "justify": "center",
    "classes": "table table-striped",
    "na_rep": "",
}





def archive_gtotalmens(idvent, dt):
    csvname = "{:03}{}_archive_totalmens.csv".format(idvent, dt)

    colnames = [
        "Identifiant",
        "Total",
        "Perpétuel en valeur absolue",
        "Perpétuel en valeur reelle",
        "Taux 01",
        "Montant tva  01",
        "Taux 02",
        "Montant tva  02",
        "Taux 03",
        "Montant tva  03",
        "Taux 04",
        "Montant tva  04",
        "Taux 05",
        "Montant tva  05",
        "Taux 06",
        "Montant tva  06",
        "Taux 07",
        "Montant tva  07",
        "Taux 08",
        "Montant tva  08",
        "Taux 09",
        "Montant tva  09",
        "Report",
        "Signature",
        "Signature précédente"
    ]

    return lire_archive(csvname, colnames, "gtotalmens", "Grand total mensuel")


def archive_gtt(idvent, dt, periode, encoding):
    csvname = "{:03}{}_".format(idvent, dt)
    csvname += "archive_totaux.csv" if periode == 1 else "archive_jourmens.csv"
    orig_csvname = csvname
    html_txt = ""
    # <!-- TABLE DU GRAND TOTAL -->

    TVA = {
        "title": "",
        "names": ["Montant TTC", "Taux TVA"],
        "csvcolnames": [
            "Montant TTC  01",
            "Taux 01",
            "Montant TTC  02",
            "Taux 02",
            "Montant TTC  03",
            "Taux 03",
            "Montant TTC  04",
            "Taux 04",
            "Montant TTC  05",
            "Taux 05",
            "Montant TTC  06",
            "Taux 06",
            "Montant TTC  07",
            "Taux 07",
            "Montant TTC  08",
            "Taux 08",
            "Montant TTC  09",
            "Taux 09"
        ],
    }

    colnames = [
        "Identifiant",
        "Total",
        "Perpétuel en valeur absolue",
        "Perpétuel en valeur réelle",
        TVA,
        "Date",
        "Report",
        "Signature",
        "Signature précédente"
    ]

    styles = ["", "", "", "", "", "", "", "", ""]
    navigations = []

    if periode == 1:
        with open("output/" + csvname, "r", encoding=encoding) as fp, open(
            "output/" + csvname + "01", "w", encoding=encoding
        ) as out, open("output/" + csvname + "02", "w", encoding=encoding) as out2:
            line = fp.readline()
            print(line, file=out, end="")

            line = fp.readline()
            while line:
                print(line, file=out2, end="")
                line = fp.readline()

        titre = "Grand total journalier"
        id_nav = "gtotaljour"

        nav, html_txt = lire_archive(csvname + "01", colnames, id_nav, titre, styles, subtitle=orig_csvname)
        navigations.extend(nav)
        csvname += "02"

    if periode == 1:
        titre = "Grands totaux factures"
    else:
        titre = "Grands totaux jours"

    id_nav = "gtotaux"

    nav, txt = lire_archive(csvname, colnames, id_nav, titre, subtitle=orig_csvname)
    navigations.extend(nav)
    html_txt += txt

    return navigations, html_txt




def archive_complement(idvent, dt):
    csvname = "{:03}{}_archive_complements.csv".format(idvent, dt)

    id_nav = "compl_facture"
    titre = "Complements facture"

    colnames = [
        "Identifiant",
        "Client",
        "Contact",
        "Adresse",
        "Code postal",
        "Ville",
        "Pays",
        "Siret",
        "NAF",
        "TVA Intra.",
        "Facture",
        "Report",
        "Signature",
        "Signature precedente",
    ]

    return lire_archive(csvname, colnames, id_nav, titre)


def archive_lignes(idvent, dt):
    csvname = "{:03}{}_archive_lignes.csv".format(idvent, dt)

    id_nav = "ligne_facture"
    titre = "Lignes facture"

    colnames = [
        "Identifiant",
        "Num. facture",
        "Num. ligne",
        "Regroupement de consommation",
        "code article",
        "Origine",
        "Libellé",
        "Quantité",
        "Code tva",
        "Taux tva",
        "Code tarif",
        "Prix tarif",
        "Prix unitaire HT",
        "Prix unitaire TTC",
        "Code remise",
        "Taux remise",
        "Montant remise",
        "Montant HT",
        "Montant TTC",
        "Montant TVA",
        "Quantité mesure",
        "Unité mesure",
        "Opération",
        "Opérateur",
        "Date",
        "Code centre profit",
        "Caisse",
        "Vendeur",
        "Code opération",
        "Code comptable",
        "Taux de service",
        "Mode de calcul du service",
        "Montant service"
    ]

    return lire_archive(csvname, colnames, id_nav, titre)


def archive_dupl(idvent, dt):
    csvname = "{:03}{}_archive_dupl.csv".format(idvent, dt)

    id_nav = "duplicat"
    titre = "Duplicata"

    colnames = [
        "Identifiant",
        "Numéro du document",
        "Numéro de ré-impression",
        "Nombre de ligne d'encaissement",
        "Type de document",
        "Opérateur",
        "Date",
        "Report",
        "Signature",
        "Signature précédente",
        "Version logiciel"
    ]
    return lire_archive(csvname, colnames, id_nav, titre)


def archive_jet(idbase, dt, periode):
    csvname = "{:02}_{}_".format(idbase, dt)
    csvname += "archive_jet.csv" if periode == 1 else "archive_jetmens.csv"

    id_nav = "jet"
    titre = "Journal des evenements techniques"

    colnames = [
        "Identifiant",
        "Code",
        "Description",
        "Login",
        "Session",
        "Date",
        "Report",
        "Signature",
        "Signature précédente",
    ]
    return lire_archive(csvname, colnames, id_nav, titre)


def archive_emetteur(idbase, dt):
    csvname = "{:03}{}_".format(idbase, dt)
    csvname += "archive_emetteur.csv"

    id_nav = "emetteur"
    titre = "Émetteur"

    colnames = [
        "SOC-NID",
        "SOC-RSO",
        "SOC-ADR",
        "SOC-CCP",
        "SOC-VIL",
        "SOC-PAYS",
        "SOC-TYPE",
        "SOC-CAPITAL",
        "SOC-TVA-NUM",
        "SOC-SIREN",
        "SOC-SIRET",
        "SOC-RCS",
        "SOC-GREFFE",
        "SOC-METIER",
        "SOC-NAF",
        "SOC-ID-MANDAT",
        "SOC-REF-MANDAT",
        "SOC-REF-REGTVA",
        "SOC-SIREN-ETAB",
        "SOC-RSO-ETAB",
        "SOC-ADR-ETAB",
        "SOC-CCP-ETAB",
        "SOC-VIL-ETAB",
        "SOC-PAYS-ETAB",
        "SOC-REF-REP",
        "SOC-NID-REP",
        "SOC-RSO-REP",
        "SOC-ADR-REP",
        "SOC-CCP-REP",
        "SOC-VIL-REP",
        "SOC-PAYS-REP",
        "SOC-TVA-REP"
    ]
    return lire_archive(csvname, colnames, id_nav, titre)
