"""
[design]/
    - config.yaml
    - class.py
    - templates/[design]/*.tex.tpl
    - examples/[design]/*.json
    - img/[design]/*.png

"""



from pathlib import Path
import string
import sys

design = sys.argv[1]
display_nom = sys.argv[2]
design_path = Path("plugins") / design

# if design_path.is_dir():
#     print(f"Le dossier {design} existe déjà. Impossible de créer ce design.")
#     sys.exit(1)

assert all(c in string.ascii_letters + string.digits for c in design)

templates_path = design_path / "templates" / design
examples_path = design_path / "examples" / design
config_path = design_path / "config.yaml"

design_path.mkdir(parents=True, exist_ok=True)
templates_path.mkdir(parents=True, exist_ok=True)
examples_path.mkdir(parents=True, exist_ok=True)
(design_path / "img").mkdir(parents=True, exist_ok=True)


with open(config_path, "w") as f:
    f.write(f"""\
%YAML 1.1
---
{design}:
  display_nom: '{display_nom}'
  gondole:
    papiers_paysage : {{"a4": False, "a7": True, "a0": True}}
    margins : {{"a4": {{"top":"1cm","left":"1cm","eti_right":"3mm","eti_bot":"1cm"}}}}
    categories:
      gondole:
        text : gondole
  a7:
    papiers_paysage : {{"a4": True, "a7": True, "a0": True}}
    bgcolor : [255,255,255] # Blanc
    fgcolor : [219,10,29]    # Rouge
    color2  : [255,220,0]
    font_dossier: ./fonts/
    font : Museo Sans Condensed 300.otf
    font_nombre : KimberleyRg-Bold.otf
    font_designation : MuseoSansCondensed500.otf
    font_euro : EuroSansStd-Bold.ttf
    font_categorie : MuseoSansCondensed-700.ttf
    margins : {{"a4": {{"top":"2cm","left":"2cm","eti_right":"5mm","eti_bot":"5mm"}}}}
    frame: False
    categories:
      VUALATV:
        text : "VU À LA TV"
        fontsize : 40
      REMB:
        text : "100% Remboursé"
        fontsize : 35
        RGB : [255,220,0]
      OPE:
        text : OPÉ
        fontsize : 40
        RGB: []
      PUB:
        text : PUB
        fontsize : 40
        RGB: []
      PROMO:
        text: PROMO
        fontsize: 40
        RGB: []
      ASAISIR:
        text: À SAISIR !
        fontsize: 40
        RGB: []
        img: chronoA4.png
        show_taux: True


""")
