from typing import Optional, List, Literal

from .compat import is_centos6

if is_centos6():
    BaseModel = object
    def Field(default=None, **kwargs):
        return default
else:
    from pydantic import BaseModel, Field


class Prix(BaseModel):
    ht: float
    ttc: float
    tva: float


class PrixPromo(BaseModel):
    prix: Optional[float] = None


class Article(BaseModel):
    code: str
    designation: str
    designationCom: Optional[str] = None
    format: Optional[str] = None
    categorie: str
    barcode: str
    nombex: int = Field(default=1, ge=1)
    contenance: float
    unite: str

    prix: Prix
    prix_ancien: Optional[Prix] = None
    promo_tarif: Optional[PrixPromo] = None

    bgcolor: Optional[List[int]] = None
    fgcolor: Optional[List[int]] = None

    font_designation: Optional[str] = None
    font_devise: Optional[str] = None
    font_dossier: Optional[str] = None


class EtiquetteDocument(BaseModel):
    modele: str
    papier: str
    output: str
    format: Optional[str] = None
    landscape: Optional[bool] = False
    articles: List[Article]
