import logging
from typing import Optional
import subprocess
from pathlib import Path

logger = logging.getLogger(__name__)

def barcode_as_img_with_zint(code: str, output: Path) -> Optional[Path]:
    if not code:
        # TODO retourner une image vide
        return None
    try:
        command = f"zint -b CODE128 -d {code} -o '{output}' --notext"
        result = subprocess.run(command, shell=True, check=True, capture_output=True)
        if result.returncode != 0:
            logger.error("Erreur Zint : %s", result.stderr.decode())
            return None
    except Exception as e:
        logger.exception("Erreur génération code-barres Zint: %s", e)
        return None
    return output


def barcode_as_img(code, output):
    """Converti le codebar (str) en image de taille 120x32"""
    if not code:
        # TODO retourner une image vide
        return None

    epsfile = output.with_suffix('.eps')
    try:
        x = subprocess.check_call("barcode -E -b{0} -o {1} -u mm -g 120x32".format(code, epsfile).split())
        subprocess.check_call(["epstopdf", str(epsfile)])

    except Exception as e:
        print ("etiquettes.py", e)
        return None
    # print(f"dvipng -T tight -x 6000 -z 9 -bg transparent -o {output} {dvifile}")
    # subprocess.check_call(
    #     f"dvipng -T tight -x 6000 -z 9 -bg transparent -o {output} {dvifile}".split())#    stdout=devnull, stderr=devnull)
    return output