import importlib.resources
import json
from pathlib import Path
import re
import urllib.parse
import importlib
from importlib.resources import files

def format_data(data: dict, addReturnType=False) -> str:
    # _data = json.dumps(data, default=str)
    # _data = json.loads(_data)

    _data = {'json_data': data}
    if addReturnType:
        _data['returnType'] = 'show'
    _data = urllib.parse.urlencode(_data, quote_via=urllib.parse.quote)
    return _data

def unformat_data(data: str) -> dict:
    _data = urllib.parse.unquote(data).replace("json_data=", "").replace("'", '"')

    return json.loads(_data)

def charger_indicatifs() -> dict:
    # importlib.resources.files
    path = importlib.resources.files("gescokit.crm.adelya").joinpath("data/indicatifs.json")
    return json.loads(path.read_text(encoding="utf-8"))

INDICATIFS = charger_indicatifs()
# INDICATIFS = {}
# with open(str(Path(__file__).absolute().parent / "data/indicatifs.json"), "r") as fp:
#     INDICATIFS = json.load(fp)

def add_prefix_to_tel(portable):
    """Ajoute le prefixe international au numero de telephone.

    Le prefixe international est devine a partir du prefixe local du numero de telephone.
    Soit +590 pour 0690/0691, +596 pour 0696/0697 et +594 pour 0694.
    Paramenters
    ----------
    tel : str
        Numero de telephone a formater. Il ne sera formate que si il est de longueur 10.

    Returns
    -------
    str
        Numero de telephone formate.
    """

    # Suppression de tous les espaces
    tel = re.sub(r" ", "", portable).strip()
    if tel and len(tel) == 10 and tel[0]=='0':
        if ind := INDICATIFS.get(tel[:4], None):
            return ind + tel[1:]
    return tel

