import pytest
from typer.testing import CliRunner
from gescokit.cli import app

runner = CliRunner()

def test_fidMember_by_cardnumber_mock(monkeypatch):
    class MockAdelya:
        def get_fidMember_by_cardnumber(self, cardnumber):
            return True, {"name": "Jean", "cardnumber": cardnumber}

    from gescokit.crm import adelya
    monkeypatch.setattr(adelya.cli, "get_adelya_instance", lambda config, country: MockAdelya())

    result = runner.invoke(app, ["adelya", "fidMember_by_cardnumber", "12345678"])
    assert result.exit_code == 0
    assert "Jean" in result.output
    assert "12345678" in result.output
