import os

def is_centos6() -> bool:
    try:
        if os.path.exists("/etc/centos-release"):
            with open("/etc/centos-release") as f:
                content = f.read()
                return "CentOS release 6" in content
        elif os.path.exists("/etc/redhat-release"):
            with open("/etc/redhat-release") as f:
                content = f.read()
                return "CentOS release 6" in content or "Red Hat Enterprise Linux Server release 6" in content
    except Exception:
        pass
    return False

USE_PYDANTIC = not is_centos6()

if USE_PYDANTIC:
    from pydantic import BaseModel
else:
    # Stub class to avoid code crash
    class BaseModel:
        def __init__(self, **kwargs):
            for k, v in kwargs.items():
                setattr(self, k, v)

if USE_PYDANTIC:
    from pydantic import validator, Field
else:
    def validator(*args, **kwargs):
        def dummy(f):
            return f
        return dummy
    Field = lambda *args, **kwargs: None