import typer
from trogon.typer import init_tui

from gescokit.common.compat import is_centos6
from gescokit.crm.adelya.cli import app as adelya_app
from gescokit.partners.kiabi.cli import app as kiabi_app
from gescokit.api.gifi.cli import app as gifi_app

app = typer.Typer(help="Gescokit - boîte à outils pour la gestion commerciale")

# Sous-commandes
app.add_typer(adelya_app, name="adelya", help="Commandes liées à l'API CRM Adelya")
app.add_typer(kiabi_app, name="kiabi", help="Commandes pour les invoices Kiabi (OneTouch)")
app.add_typer(gifi_app, name="gifi", help="Commandes API Gifi")

if not is_centos6():
    from gescokit.etiquettes.cli import app as etiquettes_app
    app.add_typer(etiquettes_app, name="labels", help="Génération d'étiquettes au format PDF")

init_tui(app)

if __name__ == "__main__":
    app()

