def lambda_int (chaine: str) -> int:
    """
    Convertit une chaîne de caractères en entier.

    :param str: Chaîne de caractères à convertir.
    :return: Entier correspondant à la chaîne de caractères. 0 si la chaine est vide ou non convertible.
    """

    if not chaine.strip():
        return 0
    
    return int(chaine.strip())

def lambda_date(chaine: str, fmt: str) -> str:
    """
    Convertit une chaîne de caractères en date au format spécifié.

    :param chaine: Chaîne de caractères à convertir.
    :param fmt: Format de la date (ex: "%Y-%m-%d").
    :return: Date au format spécifié. Retourne une chaîne vide si la conversion échoue.
    """
    
    from datetime import datetime

    try:
        return datetime.strptime(chaine.strip(), fmt).strftime("%d-%m-%Y")
    except ValueError:
        return ""
    

def lambda_YYYYMMDD(chaine: str) -> str:
    """
    Convertit une chaîne de caractères en date au format AAAAMMJJ.

    :param chaine: Chaîne de caractères à convertir.
    :return: Date au format AAAAMMJJ. Retourne une chaîne vide si la conversion échoue.
    """
    
    return lambda_date(chaine, "%Y%m%d")