import sys
import os
import subprocess

from dataclasses import dataclass
import datetime
from datetime import date
from pathlib import Path
import pprint as pp
import sys
import subprocess as sp
import argparse
import warnings
# import urllib2
# import time
# import smtplib
# from email.MIMEMultipart import MIMEMultipart
# from email.MIMEText import MIMEText

from pathlib import Path
CURDIR = Path(__file__).parent
sys.path.append(str(CURDIR.parent / ".."))

__VERSION__="1.0.1"
__CDC_VERSION__="1.4.2" # Version du cahier des charges
__DESCRIPTION__="""Flux S6 -Articles
Nom zone                   | Type  | Dont déc |   Déb     |     Fin      |  O/F |            Description            |

Code opération             | Alpha |          |     1     |     1        |   O  |Non utilisé, contient toujours ‘M’ |
Code article               | Alpha |          |     2     |     14       |   O  |       Code article GIFI           |
EAN principal              | Alpha |          |    15     |     27       |   O  |      EAN principal (GIFI)         |
Désignation 1              | Alpha |          |    28     |     47       |   O  |   Désignation article (courte)    |
Écotaxes                   | Alpha |          |    48     |     67       |   O  |Caractères 1 à 6 : montant hors taxes de l’écotaxe DEEE (à blanc si non applicable).
                                                                                 Partie entière sur les caractères 1 à 4, partie décimale sur les caractères 5 à 6.
                                                                                 Caractères 7 à 12 : montant hors taxes de l’écotaxe écomobilier (à blanc si non applicable).
                                                                                 Partie entière sur les caractères 7 à 10, partie décimale sur les caractères 11 à 12.|
Caractères 13 à 20 : inutilisés.|
Désignation 3              | Alpha |          |    68     |     117      |   O  |    Désignation article (courte)   |
Famille                    | Alpha |          |    118    |     126      |   O  | Code famille (hiérarchie groupe marchandise, 3ème niveau)  |
Sous-classe                | Alpha |          |    127    |     135      |   O  | Code sous-classe (hiérarchie groupe marchandise, 2ème niveau)  |
Classe                     | Alpha |          |    136    |     144      |   O  | Code classe (hiérarchie groupe marchandise, premier niveau)  |
Gamme                      | Alpha |          |    145    |     147      |   O  | Code gamme (hiérarchie commerciale, 3ème niveau)  |
Univers                    | Alpha |          |    148    |     150      |   O  | Code univers (hiérarchie commerciale, 2ème niveau)  |
Catégorie                  | Alpha |          |    151    |     153      |   O  | Code catégorie (hiérarchie commerciale, premier niveau)  |
Cycle de vie               | Alpha |          |    154    |     154      |   O  | Cycle de vie du produit  |
Code fournisseur           | Alpha |          |    155    |     164      |   O  | Code fournisseur pour les produits achats directs (vide si le fournisseur est GIFI)  |
Référence fournisseur      | Alpha |          |    165    |     179      |   O  | Référence du produit chez le fournisseur  |
PCB                        | Num   |          |    180    |     184      |   F  | Nombre d’articles par carton  |
Sous-PCB                   | Num   |     0    |    185    |     189      |   F  | Nombre d’articles par sous-carton  |
Prix d’achat               | Num   |     0    |    190    |     202      |   O  | Prix d’achat à la centrale GIFI ou au fournisseur direct (HT)  |
Prix de vente              | Num   |     3    |    203    |     215      |   O  | Prix de vente conseillé  |
Code classif fiscale (TVA) | Alpha |     3    |    216    |     216      |   F  | Code classification fiscale (TVA) France ðVoir liste de valeurs  |
Flag ré-étiquetage         | Alpha |          |    217    |     217      |   F  | O=Oui, N ou vide=Non  |
Unité de vente             | Alpha |          |    218    |     218      |   O  | U=Unité, K=Kilo, M=Mètre, L=Litre  |
Blocage vente              | Alpha |          |    219    |     219      |   O  | c  |
Inutilisé                  | Alpha |          |    220    |     220      |   F  |  ‘N’ |
Mode enregistrement        | Alpha |          |    221    |     221      |   F  |C=Consigné, D=Déconsigné, N=Négatif, S=Standard, T=Taxé   |
Date de mise à jour        | Num   |     0    |    222    |     229      |   O  |  Date du traitement |
Unité de conditionnement   | Alpha |          |    230    |     230      |   F  | Indique si le prix est au mètre, au litre, etc.Ex : M=Mètre, L=Litre, etc.  |
Contenance                 | Num   |     3    |    231    |     237      |   F  | Nombre d’unités selon l’unité de conditionnement  |



"""
import pandas as pd

FIXEDWIDTH = [
        (1,  "code_op", "ope"),
        (13, "code_article", "cod"),
        (13, "ean", "ean"),
        (20, "designation", "desc"),
        (20, "ecotaxes", "ecotaxes"),
        (50, "designation_3", "desig"),
        (9,  "code_famille", "gfsfam"),
        (9,  "sous_classe", "gffam"),
        (9,  "classe", "gfuni"),
        (3,  "gamme", "gfmod"),
        (3,"univers", "gfray"),
        (3,"categorie", "gfzon"),
        (1,"cycle_vie", "cycle"),
        (10,"code_fournisseur", "fou"),
        (15,"ref_fournisseur", "reffou"),
        (5,"pcb", "colcond"),
        (5,"sous_pcb", "colach"),
        (13,"prix_achat", "pa"),
        (13,"prix_vente", "pv"),
        (1,"tva", "tva"),
        (1,"is_reetiqueter", "saisie"),
        (1,"unite_vente", "uv"),
        (1,"blocage_vente", "bloq"),
        (1,"inutilise", "fcomp"),
        (1,"mode_enregistrement", "mode"),
        (8,"date_maj", "datmaj"),
        (1,"unite_conditionnement", "unitc"),
        (7,"contenance", "cont")
    ]

@dataclass
class Tcxartp2:
    code_op:str      #
    code_article: str   # Code article GIFI
    ean: str            # EAN principal (GIFI)
    designation: str    # Désignation article (courte)

    ecotaxes: str       # Caractères 1 à 6 : montant hors taxes de l’écotaxe DEEE (à blanc si non applicable). Partie entière sur les caractères 1 à 4, partie décimale sur les caractères 5 à 6.
                        # |Caractères 7 à 12 : montant hors taxes de l’écotaxe écomobilier (à blanc si non applicable). Partie entière sur les caractères 7 à 10, partie décimale sur les caractères 11 à 12.
                        # |Caractères 13 à 20 : inutilisés.
    deee: int           # montant hors taxes de l’écotaxe DEEE (à blanc si non applicable). Partie entière sur les caractères 1 à 4, partie décimale sur les caractères 5 à 6.
    ecomeuble: int      #

    designation_3: str  # Désignation article (longue)
    code_famille: str   # famille (hiérarchie groupe marchandise, 3ème niveau)
    sous_classe: str       #hiérarchie groupe marchandise, 2ème niveau
    classe:str             #hiérarchie groupe marchandise, premier niveau
    gamme: str             #hiérarchie commerciale, 3ème niveau
    univers: str           #hiérarchie commerciale, 2ème niveau
    categorie: str         #hiérarchie commerciale, premier niveau
    cycle_vie: str         #Cycle de vie du produit
    code_fournisseur: int   #vide si le fournisseur est GIFI
    ref_fournisseur: int   #Référence du produit chez le fournisseur
    pcb:int                #Nombre d’articles par carton
    sous_pcb: int          #Nombre d’articles par sous-carton
    prix_achat: str        #Prix d’achat à la centrale GIFI ou au fournisseur direct (HT)
    prix_vente: str        #Prix de vente conseillé
    tva: float             #Code classification fiscale (TVA) Franceð  Voir liste de valeurs
    is_reetiqueter:bool    #O=Oui, N ou vide=Non
    unite_vente: int       #U=Unité, K=Kilo, M=Mètre, L=Litre
    blocage_vente: bool    #O=Oui, N=Non. Indique si l’article est interdit à la vente en magasin (non-conformité, dangereux, etc.)
    inutilise: bool        #'N'
    mode_enregistrement: int  #C=Consigné, D=Déconsigné, N=Négatif, S=Standard, T=Taxé
    date_maj: int           #Date du traitement
    unite_conditionnement: int #Indique si le prix est au mètre, au litre, etc.Ex : M=Mètre, L=Litre, etc.
    date_maj: date
    unite_conditionnement: int
    contenance: int         #Nombre d’unités selon l’unité de conditionnement


    errors: dict = None
    line: str = None
    code_article_orig: str = None

    FIXEDWIDTH = FIXEDWIDTH
    EMC2_ATTR_EQUIV = {emc2_attr: attr for _, attr, emc2_attr in FIXEDWIDTH}

    @staticmethod
    def __sanity_check_dict(kwargs):
        kwargs["errors"] = {}
        code_article = kwargs["code_article"].replace(" ", "0")
        if not code_article.isdigit():
            kwargs["errors"]["code_article"] = "le code article n'est pas un nombre"
        else:
            # Convertir en int, ajouter des 0 à gauche si moins de 6 caractères puis convertir en str
            code_article = f"{int(code_article):06d}"
            kwargs["code_article"] = code_article

        kwargs["code_article"] = code_article


        ecotaxes = kwargs.get("ecotaxes")
        deee = ecotaxes[0:6].replace(" ", "0")

        deee_cent = deee[0:4]
        deee_dec = deee[4:6]


        # if kwargs["code_article"] == "0000000623696":
        #     print(deee, deee_cent, deee_dec)
        #     # Attention ! On ne supprime que les blancs les plus à gauche de l'écotaxe
        #     if deee_cent.lstrip().isdigit() and deee_dec.isdigit():
        #         deee = 100 * int(deee_cent) + int(deee_dec)
        #         print(deee_cent, int(deee_cent), deee_dec, int(deee_dec), 100 * int(deee_cent) + int(deee_cent))
        # Attention ! On ne supprime que les blancs les plus à gauche de l'écotaxe
        if deee_cent.lstrip().isdigit() and deee_dec.isdigit():
            deee = 100 * int(deee_cent) + int(deee_dec)
        else:
            deee = None
        kwargs["deee"] = deee

        ecomeuble = ecotaxes[6:12].replace(" ", "0")
        ecomeuble_cent = ecomeuble[0:4]
        ecomeuble_dec = ecomeuble[4:6]
        # if kwargs["code_article"] == "0000000623648":
        #     print(f"+{ecomeuble}+", ecomeuble_cent, ecomeuble_dec, 100 * int(ecomeuble_cent) + int(ecomeuble_dec))

        # Attention ! On ne supprime que les blancs les plus à gauche de l'écotaxe
        if ecomeuble_cent.lstrip().isdigit() and ecomeuble_dec.isdigit():
            ecomeuble = 100 * int(ecomeuble_cent) + int(ecomeuble_dec)
        else:
            ecomeuble = None
        kwargs["ecomeuble"] = ecomeuble

        # self.deee = int(self.ecotaxes[0:6])
        # self.ecomeuble = int(self.ecotaxes[6:12])
        # self.date_mag = datetime.datetime.strptime(str(self.date_maj), "%Y%m%d").date()
        # self.tva = float(self.tva)
        # self.is_reetiqueter = self.is_reetiqueter == "O"
        # self.blocage_vente = self.blocage_vente == "O"
        # self.inutilise = self.inutilise == "N"
        # self.unite_vente = int(self.unite_vente)
        # self.mode_enregistrement = int(self.mode_enregistrement)
        # self.pcb = int(self.pcb)
        # self.sous_pcb = int(self.sous_pcb)
        # self.prix_achat = float(self.prix_achat)
        # self.prix_vente = float(self.prix_vente)
        # self.contenance = int(self.contenance)
        # self.date_maj = datetime.datetime.strptime(str(self.date_maj), "%Y%m%d").date()
        # self.deee = int(self.ecotaxes[0:6])
        # self.ecomeuble = int(self.ecotaxes[6:12])

    @staticmethod
    def __convert_line_to_dict(line):
        kwargs = {"line": line}
        for width, attr, _ in FIXEDWIDTH:
            kwargs[attr] = line[:width]
            # if attr == "ecotaxes":
            #     taxes = kwargs[attr].strip()
            #     # if taxes:
            #     #     print( kwargs['code_article'], end=" ")
            #     #     print(taxes)
            line = line[width:]
        # Sauvegarde du code code article tel que renseigné dans le fichier
        # car il sera modifié par la méthode __sanity_check_dict
        kwargs["code_article_orig"] = kwargs["code_article"]
        return kwargs

    @staticmethod
    def read_line(line):
        data = Tcxartp2.__convert_line_to_dict(line)
        Tcxartp2.__sanity_check_dict(data)
        return Tcxartp2(**data)

    @staticmethod
    def read_file(filename):
        tcxartp2 = []
        with open(filename, "r") as fp:
            for line in fp:
                tcxartp2.append( Tcxartp2.read_line(line))
                yield Tcxartp2.read_line(line)

        # return tcxartp2

    def to_dict(self):
        return self.__dict__

    def get_emc2_attr(self, attr):
        if not attr in self.EMC2_ATTR_EQUIV:
            return None
        return getattr(self, self.EMC2_ATTR_EQUIV[attr])

    def is_updated(self):
        """Recherche, par ordre d'importance, si l'article a été modifié"""
        article  = pyisql.article.get_article_by_code(self.code_article)
        if article is None:
            # print("Article inexistant. Il sera créé")
            return True
        if self.ecomeuble != int( float(article["ecombl"])*100):
            # print("Ecomeuble différent", f"{self.ecomeuble} != {int(float(article['ecombl'])*100)}")
            return True
        if self.deee != int(float(article["ecotaxe"])*100):
            # print("Deee différent", f"{self.deee} != {int(float(article['ecotaxe'])*100)}")
            return True
        if self.get_emc2_attr("desig").strip() != article["desig"].strip():
            # print("Designation différente", f'+{self.get_emc2_attr("desig").strip()}+', f'+{article["desig"].strip()}+')
            return True

        # vrev = pyisql.article.get_vrev_by_code(article["code"])
        return False

def resume_header():
    return ";".join([
        "code_article", "designation",
        "deee avt (cts)", "deee aprs (cts)",
        "eco-meuble avt (cts)", "eco-meuble aprs (cts)",
        "PU HT", "PU TTC", "PU Caisse"])

def resume_line(artp2, article):
    if article['puttc'] is None:
        article['puttc'] = 0
    data = [artp2.code_article, artp2.designation_3,
            int(float(article["ecotaxe"])*100), artp2.deee,
            int(float(article["ecombl"])*100), artp2.ecomeuble,
            # article["puht"], f"{float(article['puttc']) + float(article['ecombl']):.2f}"
            article["puht"], f"{article['puttc']:.2f}", f"{article['pucaisse']:.2f}"
            ]

    assert len(data) == len(resume_header().split(";"))
    return ";".join(map(str, data))


# Sur la centos9 on placera xbase dans /home/gestcom/bin/xbase alors que sur la centos6 on le placera dans /home/gestcom/xbase
XBASE = Path("/home/gestcom/bin/xbase") if Path("/home/gestcom/bin/xbase").is_file() else Path("/home/gestcom/xbase")

def recart(codeart, args, user, dbpath, rightpath):
    puht = puttc = pucaisse = None
    cmd = [ str(XBASE) ] + f"--db-path {dbpath} --rightpath {rightpath} -u {user} --ignore-db-vers ".split()
    cmd.extend(["--numsoc", args.numsoc, "--numdep", args.numdep])
    cmd.append("recart")
    cmd.append(f'{{\"motif\":\"{codeart}\",\"typ\":\"cod\",\"qt\":1}}')

    data = subprocess.run(cmd,env=os.environ, capture_output=True, text=True)
    try:
        if articles:=json.loads(data.stdout).get("articles"):
            puttc = articles[0].get("puttc")
            pucaisse = articles[0].get("pucaisse")
            puht = articles[0].get("puht")
        else:
            print(f"Erreur lors de la recherche de l'article {codeart}")
            print(data)
    except Exception as e:
        print(e)
        puttc = puht = pucaisse = None
    return puht, puttc, pucaisse

if __name__ == "__main__":
    import argparse

    parser = argparse.ArgumentParser(description="Lecture du fichier tcxartp2.dat")
    parser.add_argument("fichier", help="Fichier tcxartp2.dat")
    # parser.add_argument("--dbpath", help="Chemin de la base de données")
    # parser.add_argument("--rightpath", help="Chemin des droits")
    # parser.add_argument("--user", help="Utilisateur")
    # parser.add_argument("--xbase", help="Chemin de l'exécutable xbase")
    parser.add_argument("--numsoc", help="Numéro de société", default=1)
    parser.add_argument("--numdep", help="Numéro de dépôt", default=0)

    args = parser.parse_args()
    # /home/ccopol/Workspace/clients/giflogmq/20240610/tcxartp2.dat
    fichier = Path(args.fichier)
    if not fichier.is_file():
        print(f"Fichier {fichier} non trouvé")
        sys.exit(1)

    now = datetime.datetime.now()
    import json

    if not XBASE.is_file():
        _XBASE = os.environ.get("XBASE")
        if not _XBASE:
            print(f"Fichier {XBASE} non trouvé")
            sys.exit(1)
        XBASE = Path(_XBASE)

    DBPATH = os.environ.get("DBPATH")
    RIGHTPATH = os.environ.get("RIGHTPATH")
    USER = os.environ.get("USER")
    if not DBPATH or not RIGHTPATH or not USER:
        print("Variables d'environnement DBPATH ou RIGHTPATH ou USER non définies")
        sys.exit(1)
    print("ecriture du fichier", f"articles_modifies_par_tcxartp2_{now:%Y%m%d-%H%M%S}_UTF8.jsonl")
    with open(f"articles_modifies_par_tcxartp2_{now:%Y%m%d-%H%M%S}_UTF8.jsonl", "w", encoding="UTF8") as fp, \
        open(f"articles_modifies_par_import_gifi_resume_{now:%Y%m%d-%H%M%S}_UTF8.csv", "w", encoding="UTF8") as fp_resum, \
        open(f"articles_modifies_par_tcxartp2_avec_erreurs_{now:%Y%m%d-%H%M%S}_UTF8.jsonl", "w", encoding="UTF8") as fp_err:
        print(resume_header(), file=fp_resum)
        for artp2 in Tcxartp2.read_file(fichier):
            print(artp2.code_article)
            ecotaxes = artp2.ecotaxes
            if ecotaxes.strip():
                if artp2.is_updated():
                    article  = pyisql.article.get_article_by_code(artp2.code_article)
                    if article is not None:
                        puht, puttc = recart(article["code"], args, USER, DBPATH, RIGHTPATH)
                        article["puht"] = puht
                        article["puttc"] = puttc
                        article["vrev"] = pyisql.article.get_vrev_by_code(article["code"])
                        article["errors"] = artp2.errors
                        article["artp2"] = artp2.to_dict()
                        print(json.dumps(article), file=fp)
                        print(resume_line(artp2, article),file=fp_resum)
                        # sys.exit(2)
            if artp2.errors:
                print( json.dumps(artp2.to_dict()), file=fp_err)
    print("fini")


# xbase --db-path $DBPATH --rightpath $RIGHTPATH --user $USER recart '{"motif":"000242","typ":"cod"}'