
from dataclasses import dataclass

"""
Flux S11 ? Portefeuille de commandes centrale GIFI

Liste des lignes de factures de la centrale GIFI au client correspondant aux produits exp�di�s � celui-ci depuis le dernier envoi du fichier S11. 

Structure fichier TCXLVSP1.dat :

|field_name | Nom zone	              | Type  | Lg | dec | 	Deb	|Fin	|O/F |Description|
| --------- | ----------------------- | ----- | --:| --- | ---- | ----- | -- | --------- |
|mag_id      | N. magasin             | Num	  | 10 | 0   |   1  |   10  | O| Code SAP client 'Site PDV'   |
|dt_fac      | Date de facturation    | Alpha | 8  |     |  11  |   18  | O| Date facture |
|fac_id      | N. Facture	          | Alpha | 10 | 	 |  19  |   28  | O| N. facture   |
|fac_line    | N. ligne facture       | Num	  | 6  | 0	 |  29  |   34  | O| N. poste facture |
|supp_id     | N. de support          | Alpha | 18 |     |  35  |   52  | F| N. UM    |
|supp_line   | N. ligne support       | Num	  | 3  | 0	 |  53  |   55  | F| Inutilise    |
|codart      | Code Article	          | Num	  | 13 |     |  56  |   68  | O| Code article facture |
|qtcmd       | Qt Cde	              | Num	  | 10 | 3	 |  69  |   78  | O| Quantite commandee en unite de quantite de base  |
|qt          | Qt Facture             | Num	  | 10 | 3	 |  79  |   88  | O| Quantite facturee en unite de quantite de base   |
|nb_colis    | Nbr de colis           | Num	  | 5  | 0	 |  89  |   93  | F| Inutilise    |
|prix_achat  | Prix d?achat           | Num	  | 13 | 3	 |  94  |  106  | O| Prix d?achat unitaire du poste de commande en euros  |
|pv_conseille| Prix de vente propose  | Num	  | 13 | 3   | 107  |  119  | F| Inutilise    |
|theme_ligne | Theme de la ligne	      | Alpha | 12 |	 | 120  |  131  | F| Inutilise    |
|| Theme du support	      | Alpha | 12 |	 | 132  |  143  | F| Inutilise    |
|| N. commande              | Alpha | 10 |     | 144  |  153  | F| Ne commande  |
|| N. ligne commande	      | Num   | 6  | 0   | 154  |  159  | F| Ne poste commande    |
|| Date Commande	          | Alpha | 8  |     | 160  |  167  | F| Date creation commande Format : AAAAMMJJ |   |
|| Ref commande	          | Alpha | 16 |     | 168  |  183  | F| CNP : n. devis Exchange JVi : n OT storeway  |
|| Depot d'expedition       | Alpha | 6  |     | 184  |  189  | F| Code point d?expedition  |
|| N. de transport	      | Alpha | 6  |     | 190  |  195  | F| Ne voyage    |
|| Chargement	              | Alpha | 6  |     | 196  |  201  | F| Code destinataire physique   |
|| N. conteneur             | Alpha | 15 |     | 202  |  216  | F| Inutilise    |
|| Date d'expedition	      | Num	  | 8  | 0   | 217  |  224  | O| Date d?expedition commande Format : AAAAMMJJ |
|| Date de livraison prevue |	Num	  | 8  | 0   | 225  |  232  | O| Date livraison previsionnelle Format : AAAAMMJJ  |
|| Date de mise a jour	  | Num	  | 8  | 0   | 233  |  240  | O| Date traitement flux S11 Format : AAAAMMJJ   |
|| Code operation           | Alpha | 1  |     | 241  |  241  | O| Constante = "M"  |
|| Fournisseur	          | Alpha | 10 |     | 242  |  251  | O| Inutilise    |
"""

__VERSION__="1.0.0"
__CDC_VERSION__="1.3.6"
__DESCRIPTION__="""Flux S11 – Portefeuille de commandes centrale GIFI

Liste des lignes de factures de la centrale GIFI au client correspondant aux produits
expédiés à celui-ci depuis le dernier envoi du fichier S11. 
"""

@dataclass
class FactureLine:
    """Classe pour convertir le fichier .dat en ligne de factures"""
    codart: str
    qty_cmd: float
    qty: float
    prix_achat: float
    num_line: int
    supp_id: str
    # supp_line: int
    # nb_colis: int


@dataclass
class FactureItem:
    """Classe pour importer les factures envoyées par Gifi France"""
    __dat_filename__ = "tcxlvsp1.dat"
    __flux_name__ = "S11"

    nummag: str
    dtfac: str
    numfac: str
    lines: list

    @property
    def numfacgifi(self):
        return self.numfac[-7:]



def decode_article(line):
    num_line = int(line[28:34])
    supp_id = line[34:52]
    # supp_line = int(line[53:55])
    codart = int(line[55:68])
    qtcmd = int(line[69:78]) / 10**3
    qt = int(line[78:88]) / 10**3    
    nb_colis = int(line[88:93]) if line[88:93].strip() else None
    prix_achat = int(line[93:106]) / 10**3
    # pv_conseille = int(line[106:119]) / 10**3
    # |theme_ligne | Theme de la ligne	      | Alpha | 12 |	 | 120  |  131  | F| Inutilise    |

    return {
        "num_line": num_line,
        "supp_id": supp_id,
        # "supp_line": supp_line,
        "codart" : codart,
        "qty_cmd": qtcmd,
        "qty": qt,
        # "nb_colis": nb_colis,
        "prix_achat": prix_achat
        }


# with open("/home/bases/caribdl/echanges/Import/tcxlvsp1.dat", "r") as fp:
with open("tcxlvsp1.dat", "r") as fp:

    factures = {}
    for line in fp:
        nummag = line[:10]
        dtfac  = line[10:18]
        numfac = line[18:28]
        if not numfac in factures:
            factures[numfac] = FactureItem(nummag, dtfac, numfac, [])
        factures[numfac].lines.append(FactureLine(**decode_article(line)))


print(factures.keys())
print(len(factures))
#     factures = set(factures)

# for f in factures:
#     if f.endswith("8871"):
#         print(f, f[-7:])


# f = list(factures)[-1]
# print(f, f[-7:])



# Facture GD0090133059 -> Commande 0001777
# Facture GD0090151743 -> Commande 0001778
# Facture GD0090151750 -> Commande 0001779
# Facture GD0090151753 -> Commande 0001780
# Facture GD0090236046 -> Commande 0001781
# Facture GD0090251763 -> Commande 0001782
# Facture GD0090297405 -> Commande 0001783
# Facture GD0090299168 -> Commande 0001784
# Facture GD0090297404 -> Commande 0001785
# Facture GD0090297406 -> Commande 0001786
# Facture GD0090297408 -> Commande 0001787
# Facture GD0090297409 -> Commande 0001788
# Facture GD0090299575 -> Commande 0001789
# Facture GD0090297407 -> Commande 0001790
# Facture GD0090299558 -> Commande 0001791
# Facture GD0090299556 -> Commande 0001792
# Facture GD0090297410 -> Commande 0001793
# Facture GD0090309630 -> Commande 0001794
# Facture GD0090299548 -> Commande 0001795
# Facture GD0090299563 -> Commande 0001796
# Facture GD0090297411 -> Commande 0001797
# Facture GD0090299561 -> Commande 0001798
# Facture GD0090299573 -> Commande 0001799
# Facture GD0090299167 -> Commande 0001800
# Facture GD0090309632 -> Commande 0001801
# Facture GD0090309629 -> Commande 0001802
# Facture GD0090268741 -> Commande 0001803
# Facture GD0090268809 -> Commande 0001804
# Facture GD0090269536 -> Commande 0001805
# Facture GD0090269623 -> Commande 0001806
# Facture GD0090309631 -> Commande 0001807
# Facture GD0090269624 -> Commande 0001808
# Facture GD0090269537 -> Commande 0001809
# Facture GD0090269625 -> Commande 0001810
# Facture GD0090269628 -> Commande 0001811
# Facture GD0090269626 -> Commande 0001812
# Facture GD0090310043 -> Commande 0001813
# Facture GD0090309635 -> Commande 0001814
# Facture GD0090309636 -> Commande 0001815
# Facture GD0090310042 -> Commande 0001816
# Facture GD0090310246 -> Commande 0001817
# Facture GD0090269621 -> Commande 0001818
# Facture GD0090310044 -> Commande 0001819
# Facture GD0090310253 -> Commande 0001820
# Facture GD0090269630 -> Commande 0001821
# Facture GD0090310252 -> Commande 0001822
# Facture GD0090269632 -> Commande 0001823
# Facture GD0090309639 -> Commande 0001824
# Facture GD0090310249 -> Commande 0001825
# Facture GD0090310256 -> Commande 0001826
# Facture GD0090269629 -> Commande 0001827
# Facture GD0090310257 -> Commande 0001828
# Facture GD0090310999 -> Commande 0001829
# Facture GD0090084664 -> Commande 0001830
# Facture GD0090088258 -> Commande 0001831
# Facture GD0090310248 -> Commande 0001832
# Facture GD0090084663 -> Commande 0001833
# Facture GD0090309637 -> Commande 0001834
# Facture GD0090310259 -> Commande 0001835
# Facture GD0090084661 -> Commande 0001836
# Facture GD0090084665 -> Commande 0001837
# Facture GD0090090367 -> Commande 0001838
# Facture GD0090088253 -> Commande 0001839
# Facture GD0090084660 -> Commande 0001840
# Facture GD0090088257 -> Commande 0001841
# Facture GD0090084666 -> Commande 0001842
# Facture GD0090091082 -> Commande 0001843
# Facture GD0090310039 -> Commande 0001844
# Facture GD0090088252 -> Commande 0001845
# Facture GD0090090371 -> Commande 0001846
# Facture GD0090084662 -> Commande 0001847
# Facture GD0090112978 -> Commande 0001848
# Facture GD0090091085 -> Commande 0001849
# Facture GD0090088256 -> Commande 0001850
# Facture GD0090091084 -> Commande 0001851
# Facture GD0090088360 -> Commande 0001852
# Facture GD0090092159 -> Commande 0001853
# Facture GD0090310041 -> Commande 0001854
# Facture GD0090088261 -> Commande 0001855
# Facture GD0090091081 -> Commande 0001856
# Facture GD0090102692 -> Commande 0001857
# Facture GD0090310040 -> Commande 0001858
# Facture GD0090091087 -> Commande 0001859
# Facture GD0090151745 -> Commande 0001860
# Facture GD0090133057 -> Commande 0001861
# Facture GD0090133058 -> Commande 0001862
# Facture GD0090133061 -> Commande 0001863
# Facture GD0090269627 -> Commande 0001864
# Facture GD0090112979 -> Commande 0001865
# Facture GD0090134351 -> Commande 0001866
# Facture GD0090151748 -> Commande 0001867
# Facture GD0090133063 -> Commande 0001868
# Facture GD0090309634 -> Commande 0001869
# Facture GD0090133064 -> Commande 0001870
# Facture GD0090151747 -> Commande 0001871
# Facture GD0090188539 -> Commande 0001872
# Facture GD0090188542 -> Commande 0001873
# Facture GD0090151746 -> Commande 0001874
# Facture GD0090190056 -> Commande 0001875
# Facture GD0090188541 -> Commande 0001876
# Facture GD0090189765 -> Commande 0001877
# Facture GD0090309633 -> Commande 0001878
# Facture GD0090151749 -> Commande 0001879
# Facture GD0090188546 -> Commande 0001880
# Facture GD0090188538 -> Commande 0001881
# Facture GD0090189766 -> Commande 0001882
# Facture GD0090188503 -> Commande 0001883
# Facture GD0090188547 -> Commande 0001884
# Facture GD0090189764 -> Commande 0001885
# Facture GD0090112980 -> Commande 0001886
# Facture GD0090318761 -> Commande 0001887
# Facture GD0090318767 -> Commande 0001888
# Facture GD0090190041 -> Commande 0001889
# Facture GD0090188502 -> Commande 0001890
# Facture GD0090318763 -> Commande 0001891
# Facture GD0090188543 -> Commande 0001892
# Facture GD0090211027 -> Commande 0001893
# Facture GD0090318764 -> Commande 0001894
# Facture GD0090102175 -> Commande 0001895
# Facture GD0090318768 -> Commande 0001896
# Facture GD0090102176 -> Commande 0001897
# Facture GD0090211927 -> Commande 0001898
# Facture GD0090209895 -> Commande 0001899
# Facture GD0090236044 -> Commande 0001900
# Facture GD0090319982 -> Commande 0001901
# Facture GD0090190043 -> Commande 0001902
# Facture GD0090091088 -> Commande 0001903
# Facture GD0090236043 -> Commande 0001904
# Facture GD0090190683 -> Commande 0001905
# Facture GD0090319987 -> Commande 0001906
# Facture GD0090209899 -> Commande 0001907
# Facture GD0090096030 -> Commande 0001908
# Facture GD0090211031 -> Commande 0001909
# Facture GD0090319981 -> Commande 0001910
# Facture GD0090318762 -> Commande 0001911
# Facture GD0090188545 -> Commande 0001912
# Facture GD0090112977 -> Commande 0001913
# Facture GD0090318765 -> Commande 0001914
# Facture GD0090319984 -> Commande 0001915
# Facture GD0090239770 -> Commande 0001916
# Facture GD0090190684 -> Commande 0001917
# Facture GD0090236049 -> Commande 0001918
# Facture GD0090319983 -> Commande 0001919
# Facture GD0090209892 -> Commande 0001920
# Facture GD0090236050 -> Commande 0001921
# Facture GD0090190019 -> Commande 0001922
# Facture GD0090236051 -> Commande 0001923
# Facture GD0090244575 -> Commande 0001924
# Facture GD0090239775 -> Commande 0001925
# Facture GD0090236047 -> Commande 0001926
# Facture GD0090318766 -> Commande 0001927
# Facture GD0090236052 -> Commande 0001928
# Facture GD0090236048 -> Commande 0001929
# Facture GD0090188504 -> Commande 0001930
# Facture GD0090239769 -> Commande 0001931
# Facture GD0090236045 -> Commande 0001932
# Facture GD0090209887 -> Commande 0001933
# Facture GD0090236053 -> Commande 0001934
# Facture GD0090252154 -> Commande 0001935
# Facture GD0090239773 -> Commande 0001936
# Facture GD0090244576 -> Commande 0001937
# Facture GD0090239768 -> Commande 0001938
# Facture GD0090245040 -> Commande 0001939
# Facture GD0090251761 -> Commande 0001940
# Facture GD0090239766 -> Commande 0001941
# Facture GD0090239771 -> Commande 0001942
# Facture GD0090251755 -> Commande 0001943
# Facture GD0090251759 -> Commande 0001944
# Facture GD0090250769 -> Commande 0001945
# Facture GD0090250770 -> Commande 0001946
# Facture GD0090239767 -> Commande 0001947
# Facture GD0090250774 -> Commande 0001948
# Facture GD0090251756 -> Commande 0001949
# Facture GD0090090365 -> Commande 0001950
# Facture GD0090243781 -> Commande 0001951
# Facture GD0090250775 -> Commande 0001952
# Facture GD0090243782 -> Commande 0001953
# Facture GD0090250762 -> Commande 0001954
# Facture GD0090211921 -> Commande 0001955
# Facture GD0090251757 -> Commande 0001956
# Facture GD0090251758 -> Commande 0001957
# Facture GD0090251760 -> Commande 0001958
# Facture GD0090324928 -> Commande 0001959
# Facture GD0090091086 -> Commande 0001960
# Facture GD0090250771 -> Commande 0001961
# Facture GD0090324931 -> Commande 0001962
# Facture GD0090102166 -> Commande 0001963
# Facture GD0090325198 -> Commande 0001964
# Facture GD0090243783 -> Commande 0001965
# Facture GD0090090372 -> Commande 0001966
# Facture GD0090324927 -> Commande 0001967
# Facture GD0090112975 -> Commande 0001968
# Facture GD0090324935 -> Commande 0001969
# Facture GD0090324926 -> Commande 0001970
# Facture GD0090325199 -> Commande 0001971
# Facture GD0090090368 -> Commande 0001972
# Facture GD0090112976 -> Commande 0001973
# Facture GD0090102170 -> Commande 0001974
# Facture GD0090188499 -> Commande 0001975
# Facture GD0090324929 -> Commande 0001976
# Facture GD0090091083 -> Commande 0001977
# Facture GD0090151744 -> Commande 0001978
# Facture GD0090329263 -> Commande 0001979
# Facture GD0090329262 -> Commande 0001980
# Facture GD0090151751 -> Commande 0001981
# Facture GD0090251762 -> Commande 0001982
# Facture GD0090112981 -> Commande 0001983
# Facture GD0090088255 -> Commande 0001984
# Facture GD0090090366 -> Commande 0001985
# Facture GD0090326461 -> Commande 0001986
# Facture GD0090326462 -> Commande 0001987
# Facture GD0090324925 -> Commande 0001988
# Facture GD0090324930 -> Commande 0001989
# Facture GD0090325204 -> Commande 0001990
# Facture GD0090190042 -> Commande 0001991
# Facture GD0090327374 -> Commande 0001992
# Facture GD0090329359 -> Commande 0001993
# Facture GD0090342801 -> Commande 0001994
# Facture GD0090342800 -> Commande 0001995
# Facture GD0090188540 -> Commande 0001996
# Facture GD0090326458 -> Commande 0001997
# Facture GD0090188501 -> Commande 0001998
# Facture GD0090325672 -> Commande 0001999
# Facture GD0090326455 -> Commande 0002000
# Facture GD0090325207 -> Commande 0002001
# Facture GD0090326460 -> Commande 0002002
# Facture GD0090329270 -> Commande 0002003
# Facture GD0090329261 -> Commande 0002004
# Facture GD0090325205 -> Commande 0002005
# Facture GD0090329273 -> Commande 0002006
# Facture GD0090329274 -> Commande 0002007
# Facture GD0090188500 -> Commande 0002008
# Facture GD0090325202 -> Commande 0002009
# Facture GD0090188544 -> Commande 0002010
# Facture GD0090327372 -> Commande 0002011
# Facture GD0090329614 -> Commande 0002012
# Facture GD0090327377 -> Commande 0002013
# Facture GD0090342807 -> Commande 0002014
# Facture GD0090329660 -> Commande 0002015
# Facture GD0090327371 -> Commande 0002016
# Facture GD0090342803 -> Commande 0002017
# Facture GD0090239765 -> Commande 0002018
# Facture GD0090342802 -> Commande 0002019
# Facture GD0090342806 -> Commande 0002020
# Facture GD0090342810 -> Commande 0002021
# Facture GD0090236054 -> Commande 0002022
# Facture GD0090329352 -> Commande 0002023
# Facture GD0090329335 -> Commande 0002024
# Facture GD0090329366 -> Commande 0002025
# Facture GD0090190044 -> Commande 0002026
# Facture GD0090329618 -> Commande 0002027
# Facture GD0090329255 -> Commande 0002028
# Facture GD0090330633 -> Commande 0002029
# Facture GD0090330636 -> Commande 0002030
# Facture GD0090236056 -> Commande 0002031
# Facture GD0090326452 -> Commande 0002032
# Facture GD0090342804 -> Commande 0002033
# Facture GD0090330637 -> Commande 0002034
# Facture GD0090342805 -> Commande 0002035
# Facture GD0090342811 -> Commande 0002036
# Facture GD0090251764 -> Commande 0002037
# Facture GD0090329267 -> Commande 0002038
# Facture GD0090330640 -> Commande 0002039
# Facture GD0090330639 -> Commande 0002040
# Facture GD0090342809 -> Commande 0002041
# Facture GD0090330635 -> Commande 0002042
# Facture GD0090332375 -> Commande 0002043
# Facture GD0090330655 -> Commande 0002044
# Facture GD0090330654 -> Commande 0002045
# Facture GD0090332378 -> Commande 0002046
# Facture GD0090236055 -> Commande 0002047
# Facture GD0090332383 -> Commande 0002048
# Facture GD0090332386 -> Commande 0002049
# Facture GD0090332385 -> Commande 0002050
# Facture GD0090342808 -> Commande 0002051
# Facture GD0090330634 -> Commande 0002052
# Facture GD0090332376 -> Commande 0002053
# Facture GD0090332377 -> Commande 0002054
# Facture GD0090332380 -> Commande 0002055
# Facture GD0090332382 -> Commande 0002056
# Facture GD0090332387 -> Commande 0002057
# Facture GD0090331511 -> Commande 0002058
# Facture GD0090332389 -> Commande 0002059
# Facture GD0090332388 -> Commande 0002060
# Facture GD0090330653 -> Commande 0002061
# Facture GD0090332390 -> Commande 0002062
# Facture GD0090331516 -> Commande 0002063
# Facture GD0090331513 -> Commande 0002064
# Facture GD0090334849 -> Commande 0002065
# Facture GD0090334851 -> Commande 0002066
# Facture GD0090332379 -> Commande 0002067
# Facture GD0090334853 -> Commande 0002068
# Facture GD0090334848 -> Commande 0002069
# Facture GD0090331514 -> Commande 0002070
# Facture GD0090329636 -> Commande 0002071
# Facture GD0090332391 -> Commande 0002072
# Facture GD0090332393 -> Commande 0002073
# Facture GD0090334850 -> Commande 0002074
# Facture GD0090331515 -> Commande 0002075
# Facture GD0090332381 -> Commande 0002076
# Facture GD0090332384 -> Commande 0002077
# Facture GD0090334852 -> Commande 0002078
# Facture GD0090332392 -> Commande 0002079
# Facture GD0090331510 -> Commande 0002080
# Facture GD0090331512 -> Commande 0002081
# Facture GD0090338868 -> Commande 0002082
# Facture GD0090337328 -> Commande 0002083
# Facture GD0090338877 -> Commande 0002084
# Facture GD0090338878 -> Commande 0002085
# Facture GD0090334855 -> Commande 0002086
# Facture GD0090334854 -> Commande 0002087
# Facture GD0090337475 -> Commande 0002088
# Facture GD0090334857 -> Commande 0002089
# Facture GD0090334858 -> Commande 0002090
# Facture GD0090340065 -> Commande 0002091
# Facture GD0090340068 -> Commande 0002092
# Facture GD0090340072 -> Commande 0002093
# Facture GD0090340071 -> Commande 0002094
# Facture GD0090340076 -> Commande 0002095
# Facture GD0090335199 -> Commande 0002096
# Facture GD0090337332 -> Commande 0002097
# Facture GD0090340066 -> Commande 0002098
# Facture GD0090337330 -> Commande 0002099
# Facture GD0090335200 -> Commande 0002100
# Facture GD0090340070 -> Commande 0002101
# Facture GD0090337331 -> Commande 0002102
# Facture GD0090338883 -> Commande 0002103
# Facture GD0090340067 -> Commande 0002104
# Facture GD0090340069 -> Commande 0002105
# Facture GD0090338869 -> Commande 0002106
# Facture GD0090338870 -> Commande 0002107
# Facture GD0090338880 -> Commande 0002108
# Facture GD0090340073 -> Commande 0002109
# Facture GD0090340074 -> Commande 0002110
# Facture GD0090338881 -> Commande 0002111
# Facture GD0090340075 -> Commande 0002112
# Facture GD0090330638 -> Commande 0002113
# Facture GD0090337329 -> Commande 0002114
# Facture GD0090338872 -> Commande 0002115
# Facture GD0090338879 -> Commande 0002116
# Facture GD0090338874 -> Commande 0002117
# Facture GD0090338876 -> Commande 0002118
# Facture GD0090338875 -> Commande 0002119
# Facture GD0090334856 -> Commande 0002120
# Facture GD0090338882 -> Commande 0002121
# Facture GD0090340077 -> Commande 0002122
# Facture GD0090338873 -> Commande 0002123
# Facture GD0090338871 -> Commande 0002124