from pathlib import Path
from typing import Optional
import typer
import pandas as pd

from gescokit.api.gifi.mvtp1 import Mvtp1Parser
from gescokit.api.gifi.base import doc_fields

app = typer.Typer(help="Commandes liées au fichier MVTP1")

@app.command("to-csv")
def to_csv(input: Path, output: Optional[Path] = None):
    """
    Convertit un fichier MVTP1 à largeur fixe en CSV.

    Parameters
    ----------
    input : Path
        Chemin vers le fichier d'entrée MVTP1.
    output : Path, optional
        Chemin de sortie pour le fichier CSV. Si omis, ajoute l'extension .csv.
    """
    parser = Mvtp1Parser()
    data = parser.parse_file(input)
    output = output or input.with_suffix(".csv")
    pd.DataFrame(data).to_csv(output, index=False)
    typer.echo(f"Fichier exporté : {output}")


@app.command("doc")
def doc():
    """
    Affiche la documentation des champs du fichier MVTP1.
    """
    typer.echo(doc_fields(Mvtp1Parser()))
