# cli_jrap1.py
import typer
import pandas as pd
from pathlib import Path
from typing import Optional

from gescokit.api.gifi.artp2 import Artp2Parser
from gescokit.api.gifi.base import doc_fields

app = typer.Typer(help="Commandes liées au fichier JRAP1")

@app.command("to-csv")
def to_csv(input: Path, output: Optional[Path] = None):
    """
    Convertit un fichier Article à largeur fixe en CSV.

    Parameters
    ----------
    input : Path
        Fichier source au format texte fixe.
    output : Path, optional
        Fichier de sortie CSV. Si omis, prend le nom du fichier source avec extension .csv
    """
    parser = Artp2Parser()
    data = parser.parse_file(input)
    output = output or input.with_suffix(".csv")
    pd.DataFrame(data).to_csv(output, index=False)
    typer.echo(f"Fichier exporté : {output}")


@app.command("doc")
def doc():
    """
    Affiche la documentation des champs du format JRAP1.
    """
    typer.echo(doc_fields(Artp2Parser()))
