import typer
import json
from pathlib import Path
from typing import Optional
from gescokit.api.gifi.cli_mvtp1 import app as mvtp1_app
from gescokit.api.gifi.cli_jrap1 import app as jrap1_app
from gescokit.api.gifi.cli_artp2 import app as artp2_app
from gescokit.api.gifi.mvtp1 import Mvtp1Parser
from gescokit.api.gifi.jrap1 import Jrap1Parser
from gescokit.api.gifi.artp2 import Artp2Parser
from gescokit.api.gifi.base import doc_fields

app = typer.Typer(help="Commandes liées à l'API Gifi")

app.add_typer(artp2_app, name="artp2", help="Fichier articles ARTP2")
app.add_typer(jrap1_app, name="jrap1", help="Fichier ventes JRAP1")
app.add_typer(mvtp1_app, name="mvtp1", help="Fichier mouvements MVTP1")

@app.command("doc")
def all_docs():
    """
    Affiche la documentation de tous les formats Gifi disponibles.
    """
    for parser_cls in [Mvtp1Parser, Jrap1Parser, Artp2Parser]:
        print("\n" + "=" * 80 + "\n")
        doc_fields(parser_cls())